/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserRequestFormProperty;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UserRequestFormPropertyType;
import org.apache.syncope.core.flowable.api.DropdownValueProvider;
import org.apache.syncope.core.flowable.api.UserRequestHandler;
import org.apache.syncope.core.flowable.api.WorkflowTaskManager;
import org.apache.syncope.core.flowable.impl.FlowableRuntimeUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.event.AnyDeletedEvent;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.form.FormProperty;
import org.flowable.engine.form.FormType;
import org.flowable.engine.form.TaskFormData;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.flowable.engine.runtime.NativeProcessInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public class FlowableUserRequestHandler
implements UserRequestHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(UserRequestHandler.class);
    @Autowired
    protected WorkflowTaskManager wfTaskManager;
    @Autowired
    protected UserDataBinder dataBinder;
    @Resource(name="adminUser")
    protected String adminUser;
    @Autowired
    protected DomainProcessEngine engine;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected EntityFactory entityFactory;

    protected StringBuilder createProcessInstanceQuery(String userKey) {
        StringBuilder query = new StringBuilder().append("SELECT DISTINCT ID_,BUSINESS_KEY_,PROC_DEF_ID_,PROC_INST_ID_,START_TIME_ FROM ").append(this.engine.getManagementService().getTableName(ExecutionEntity.class)).append(" WHERE BUSINESS_KEY_ NOT LIKE '").append(FlowableRuntimeUtils.getProcBusinessKey("userWorkflow", "%")).append("'");
        if (userKey != null) {
            query.append(" AND BUSINESS_KEY_ LIKE '").append(FlowableRuntimeUtils.getProcBusinessKey("%", userKey)).append("'");
        }
        query.append(" AND PARENT_ID_ IS NULL");
        return query;
    }

    protected int countProcessInstances(StringBuilder processInstanceQuery) {
        return (int)((NativeProcessInstanceQuery)this.engine.getRuntimeService().createNativeProcessInstanceQuery().sql("SELECT COUNT(ID_) FROM " + StringUtils.substringAfter((String)processInstanceQuery.toString(), (String)" FROM "))).count();
    }

    protected UserRequest getUserRequest(ProcessInstance procInst) {
        Pair<String, String> split = FlowableRuntimeUtils.splitProcBusinessKey(procInst.getBusinessKey());
        UserRequest userRequest = new UserRequest();
        userRequest.setBpmnProcess((String)split.getLeft());
        userRequest.setStartTime(procInst.getStartTime());
        userRequest.setUsername(((User)this.userDAO.find((String)split.getRight())).getUsername());
        userRequest.setExecutionId(procInst.getId());
        userRequest.setActivityId(((Task)((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(procInst.getProcessInstanceId())).singleResult()).getTaskDefinitionKey());
        return userRequest;
    }

    @Override
    @Transactional(readOnly=true)
    public Pair<Integer, List<UserRequest>> getUserRequests(String userKey, int page, int size, List<OrderByClause> orderByClauses) {
        StringBuilder query = this.createProcessInstanceQuery(userKey);
        Integer count = this.countProcessInstances(query);
        if (!orderByClauses.isEmpty()) {
            query.append(" ORDER BY");
            for (OrderByClause clause : orderByClauses) {
                boolean sorted = true;
                switch (clause.getField().trim()) {
                    case "bpmnProcess": {
                        query.append(" PROC_DEF_ID_");
                        break;
                    }
                    case "startTime": {
                        query.append(" START_TIME_");
                        break;
                    }
                    case "executionId": {
                        query.append(" PROC_INST_ID_");
                        break;
                    }
                    default: {
                        LOG.warn("User request sort request by {}: unsupported, ignoring", (Object)clause.getField().trim());
                        sorted = false;
                    }
                }
                if (!sorted) continue;
                if (clause.getDirection() == OrderByClause.Direction.ASC) {
                    query.append(" ASC,");
                    continue;
                }
                query.append(" DESC,");
            }
            query.setLength(query.length() - 1);
        }
        List result = ((NativeProcessInstanceQuery)this.engine.getRuntimeService().createNativeProcessInstanceQuery().sql(query.toString())).listPage(size * (page <= 0 ? 0 : page - 1), size).stream().map(procInst -> this.getUserRequest((ProcessInstance)procInst)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    protected User lazyLoad(User user) {
        BeanUtils.copyProperties((Object)user, (Object)this.entityFactory.newEntity(User.class));
        return user;
    }

    @Override
    public UserRequest start(String bpmnProcess, User user) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("wfExecutor", AuthContextUtils.getUsername());
        variables.put("user", (String)this.lazyLoad(user));
        variables.put("userTO", (String)this.dataBinder.getUserTO(user, true));
        ProcessInstance procInst = null;
        try {
            procInst = this.engine.getRuntimeService().startProcessInstanceByKey(bpmnProcess, variables);
        }
        catch (FlowableException e) {
            FlowableRuntimeUtils.throwException(e, "While starting " + bpmnProcess + " instance");
        }
        this.engine.getRuntimeService().updateBusinessKey(procInst.getProcessInstanceId(), FlowableRuntimeUtils.getProcBusinessKey(bpmnProcess, user.getKey()));
        return this.getUserRequest((ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInst.getProcessInstanceId()).singleResult());
    }

    @Override
    public Pair<ProcessInstance, String> parse(String executionId) {
        ProcessInstance procInst = null;
        try {
            procInst = (ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(executionId).singleResult();
            if (procInst == null) {
                throw new FlowableIllegalArgumentException("ProcessInstance with id " + executionId);
            }
        }
        catch (FlowableException e) {
            LOG.error("Could find execution ProcessInstance with id {}", (Object)executionId, (Object)e);
            throw new NotFoundException("User request execution with id " + executionId);
        }
        return Pair.of((Object)procInst, (Object)this.getUserKey(procInst.getProcessInstanceId()));
    }

    @Override
    public void cancel(ProcessInstance procInst, String reason) {
        if ("userWorkflow".equals(procInst.getProcessDefinitionKey())) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Cannot cancel a userWorkflow execution"));
        }
        this.engine.getRuntimeService().deleteProcessInstance(procInst.getId(), reason);
    }

    @Override
    public void cancelByProcessDefinition(String processDefinitionId) {
        this.engine.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinitionId).list().forEach(procInst -> this.engine.getRuntimeService().deleteProcessInstance(procInst.getId(), "Cascade Delete process definition " + processDefinitionId));
    }

    @Override
    public void cancelByUser(AnyDeletedEvent event) {
        if (AuthContextUtils.getDomain().equals(event.getDomain()) && event.getAnyTypeKind() == AnyTypeKind.USER) {
            String username = event.getAnyName();
            ((NativeProcessInstanceQuery)this.engine.getRuntimeService().createNativeProcessInstanceQuery().sql(this.createProcessInstanceQuery(event.getAnyKey()).toString())).list().forEach(procInst -> this.engine.getRuntimeService().deleteProcessInstance(procInst.getId(), "Cascade Delete user " + username));
        }
    }

    protected UserRequestFormPropertyType fromFlowableFormType(FormType flowableFormType) {
        UserRequestFormPropertyType result = UserRequestFormPropertyType.String;
        if (null != flowableFormType.getName()) {
            switch (flowableFormType.getName()) {
                case "long": {
                    result = UserRequestFormPropertyType.Long;
                    break;
                }
                case "enum": {
                    result = UserRequestFormPropertyType.Enum;
                    break;
                }
                case "date": {
                    result = UserRequestFormPropertyType.Date;
                    break;
                }
                case "boolean": {
                    result = UserRequestFormPropertyType.Boolean;
                    break;
                }
                case "dropdown": {
                    result = UserRequestFormPropertyType.Dropdown;
                    break;
                }
            }
        }
        return result;
    }

    protected UserRequestForm getForm(Task task) {
        return this.getForm(task, this.engine.getFormService().getTaskFormData(task.getId()));
    }

    protected UserRequestForm getForm(Task task, TaskFormData fd) {
        UserRequestForm formTO = this.getForm(task.getProcessInstanceId(), task.getId(), fd.getFormKey(), fd.getFormProperties());
        formTO.setCreateTime(task.getCreateTime());
        formTO.setDueDate(task.getDueDate());
        formTO.setExecutionId(task.getExecutionId());
        formTO.setFormKey(task.getFormKey());
        formTO.setAssignee(task.getAssignee());
        return formTO;
    }

    protected UserRequestForm getForm(HistoricTaskInstance task) {
        List<HistoricFormPropertyEntity> props = this.engine.getHistoryService().createHistoricDetailQuery().taskId(task.getId()).list().stream().filter(HistoricFormPropertyEntity.class::isInstance).map(HistoricFormPropertyEntity.class::cast).collect(Collectors.toList());
        UserRequestForm formTO = this.getHistoricFormTO(task.getProcessInstanceId(), task.getId(), task.getFormKey(), props);
        formTO.setCreateTime(task.getCreateTime());
        formTO.setDueDate(task.getDueDate());
        formTO.setExecutionId(task.getExecutionId());
        formTO.setFormKey(task.getFormKey());
        formTO.setAssignee(task.getAssignee());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.engine.getHistoryService().createHistoricActivityInstanceQuery().executionId(task.getExecutionId()).activityType("userTask").activityName(task.getName()).singleResult();
        if (historicActivityInstance != null) {
            formTO.setCreateTime(historicActivityInstance.getStartTime());
            formTO.setDueDate(historicActivityInstance.getEndTime());
        }
        return formTO;
    }

    protected String getUserKey(String procInstId) {
        String procBusinessKey = ((ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstId).singleResult()).getBusinessKey();
        return StringUtils.substringAfter((String)procBusinessKey, (String)":");
    }

    protected UserRequestForm getHistoricFormTO(String procInstId, String taskId, String formKey, List<HistoricFormPropertyEntity> props) {
        UserRequestForm formTO = new UserRequestForm();
        formTO.setBpmnProcess(((ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstId).singleResult()).getProcessDefinitionKey());
        User user = (User)this.userDAO.find(this.getUserKey(procInstId));
        if (user == null) {
            throw new NotFoundException("User for process instance id " + procInstId);
        }
        formTO.setUsername(user.getUsername());
        formTO.setTaskId(taskId);
        formTO.setFormKey(formKey);
        formTO.setUserTO((UserTO)this.engine.getRuntimeService().getVariable(procInstId, "userTO", UserTO.class));
        formTO.setUserPatch((UserPatch)this.engine.getRuntimeService().getVariable(procInstId, "userPatch", UserPatch.class));
        formTO.getProperties().addAll(props.stream().map(prop -> {
            UserRequestFormProperty propertyTO = new UserRequestFormProperty();
            propertyTO.setId(prop.getPropertyId());
            propertyTO.setName(prop.getPropertyId());
            propertyTO.setValue(prop.getPropertyValue());
            return propertyTO;
        }).collect(Collectors.toList()));
        return formTO;
    }

    protected UserRequestForm getForm(String procInstId, String taskId, String formKey, List<FormProperty> props) {
        UserRequestForm formTO = new UserRequestForm();
        formTO.setBpmnProcess(((ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstId).singleResult()).getProcessDefinitionKey());
        User user = (User)this.userDAO.find(this.getUserKey(procInstId));
        if (user == null) {
            throw new NotFoundException("User for process instance id " + procInstId);
        }
        formTO.setUsername(user.getUsername());
        formTO.setExecutionId(procInstId);
        formTO.setTaskId(taskId);
        formTO.setFormKey(formKey);
        formTO.setUserTO((UserTO)this.engine.getRuntimeService().getVariable(procInstId, "userTO", UserTO.class));
        formTO.setUserPatch((UserPatch)this.engine.getRuntimeService().getVariable(procInstId, "userPatch", UserPatch.class));
        formTO.getProperties().addAll(props.stream().map(fProp -> {
            UserRequestFormProperty propertyTO = new UserRequestFormProperty();
            propertyTO.setId(fProp.getId());
            propertyTO.setName(fProp.getName());
            propertyTO.setReadable(fProp.isReadable());
            propertyTO.setRequired(fProp.isRequired());
            propertyTO.setWritable(fProp.isWritable());
            propertyTO.setValue(fProp.getValue());
            propertyTO.setType(this.fromFlowableFormType(fProp.getType()));
            switch (propertyTO.getType()) {
                case Date: {
                    propertyTO.setDatePattern((String)fProp.getType().getInformation("datePattern"));
                    break;
                }
                case Enum: {
                    propertyTO.getEnumValues().putAll((Map)fProp.getType().getInformation("values"));
                    break;
                }
                case Dropdown: {
                    String valueProviderBean = (String)fProp.getType().getInformation("dropdownValueProvider");
                    try {
                        DropdownValueProvider valueProvider = (DropdownValueProvider)ApplicationContextProvider.getApplicationContext().getBean(valueProviderBean, DropdownValueProvider.class);
                        propertyTO.getDropdownValues().putAll(valueProvider.getValues());
                    }
                    catch (Exception e) {
                        LOG.error("Could not find bean {} of type {} for form property {}", new Object[]{valueProviderBean, DropdownValueProvider.class.getName(), propertyTO.getId(), e});
                    }
                    break;
                }
            }
            return propertyTO;
        }).collect(Collectors.toList()));
        return formTO;
    }

    @Override
    @Transactional(readOnly=true)
    public Pair<Integer, List<UserRequestForm>> getForms(String userKey, int page, int size, List<OrderByClause> orderByClauses) {
        Pair<Integer, List<UserRequestForm>> forms;
        String authUser;
        TaskQuery query = (TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey();
        if (userKey != null) {
            query.processInstanceBusinessKeyLike(FlowableRuntimeUtils.getProcBusinessKey("%", userKey));
        }
        if (this.adminUser.equals(authUser = AuthContextUtils.getUsername())) {
            forms = this.getForms(query, page, size, orderByClauses);
        } else {
            User user = this.userDAO.findByUsername(authUser);
            forms = this.getForms(query.taskCandidateOrAssigned(user.getUsername()), page, size, orderByClauses);
            ArrayList candidateGroups = new ArrayList(this.userDAO.findAllGroupNames(user));
            if (!candidateGroups.isEmpty()) {
                forms = this.getForms((TaskQuery)query.taskCandidateGroupIn(candidateGroups), page, size, orderByClauses);
            }
        }
        return forms == null ? Pair.of((Object)0, Collections.emptyList()) : forms;
    }

    protected Pair<Integer, List<UserRequestForm>> getForms(TaskQuery query, int page, int size, List<OrderByClause> orderByClauses) {
        for (OrderByClause clause : orderByClauses) {
            boolean sorted = true;
            switch (clause.getField().trim()) {
                case "bpmnProcess": {
                    query.orderByProcessDefinitionId();
                    break;
                }
                case "executionId": {
                    query.orderByExecutionId();
                    break;
                }
                case "taskId": {
                    query.orderByTaskId();
                    break;
                }
                case "createTime": {
                    query.orderByTaskCreateTime();
                    break;
                }
                case "dueDate": {
                    query.orderByTaskDueDate();
                    break;
                }
                case "assignee": {
                    query.orderByTaskAssignee();
                    break;
                }
                default: {
                    LOG.warn("Form sort request by {}: unsupported, ignoring", (Object)clause.getField().trim());
                    sorted = false;
                }
            }
            if (!sorted) continue;
            if (clause.getDirection() == OrderByClause.Direction.ASC) {
                query.asc();
                continue;
            }
            query.desc();
        }
        List result = query.listPage(size * (page <= 0 ? 0 : page - 1), size).stream().map(task -> task instanceof HistoricTaskInstance ? this.getForm((HistoricTaskInstance)task) : this.getForm((Task)task)).collect(Collectors.toList());
        return Pair.of((Object)((int)query.count()), result);
    }

    protected Pair<Task, TaskFormData> parseTask(String taskId) {
        TaskFormData formData;
        Task task;
        try {
            task = (Task)((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey()).taskId(taskId)).singleResult();
            if (task == null) {
                throw new FlowableException("NULL result");
            }
        }
        catch (FlowableException e) {
            throw new NotFoundException("Flowable Task " + taskId, (Exception)((Object)e));
        }
        try {
            formData = this.engine.getFormService().getTaskFormData(task.getId());
        }
        catch (FlowableException e) {
            throw new NotFoundException("Form for Flowable Task " + taskId, (Exception)((Object)e));
        }
        return Pair.of((Object)task, (Object)formData);
    }

    @Override
    public UserRequestForm claimForm(String taskId) {
        Task task;
        List tasksForUser;
        Pair<Task, TaskFormData> parsed = this.parseTask(taskId);
        String authUser = AuthContextUtils.getUsername();
        if (!this.adminUser.equals(authUser) && (tasksForUser = ((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey()).taskId(taskId)).taskCandidateOrAssigned(authUser).list()).isEmpty()) {
            throw new WorkflowException((Throwable)new IllegalArgumentException(authUser + " is not candidate nor assignee of task " + taskId));
        }
        boolean hasAssignees = this.engine.getTaskService().getIdentityLinksForTask(taskId).stream().anyMatch(identityLink -> "assignee".equals(identityLink.getType()));
        if (hasAssignees) {
            try {
                this.engine.getTaskService().unclaim(taskId);
            }
            catch (FlowableException e) {
                throw new WorkflowException("While unclaiming task " + taskId, (Throwable)e);
            }
        }
        try {
            this.engine.getTaskService().claim(taskId, authUser);
            task = (Task)((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey()).taskId(taskId)).singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While reading task " + taskId, (Throwable)e);
        }
        return this.getForm(task, (TaskFormData)parsed.getRight());
    }

    @Override
    public UserRequestForm unclaimForm(String taskId) {
        Task task;
        Pair<Task, TaskFormData> parsed = this.parseTask(taskId);
        try {
            this.engine.getTaskService().unclaim(taskId);
            task = (Task)((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey()).taskId(taskId)).singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While unclaiming task " + taskId, (Throwable)e);
        }
        return this.getForm(task, (TaskFormData)parsed.getRight());
    }

    private Map<String, String> getPropertiesForSubmit(UserRequestForm form) {
        HashMap props = new HashMap();
        form.getProperties().stream().filter(UserRequestFormProperty::isWritable).forEach(prop -> props.put(prop.getId(), prop.getValue()));
        return Collections.unmodifiableMap(props);
    }

    @Override
    public WorkflowResult<UserPatch> submitForm(UserRequestForm form) {
        Pair<Task, TaskFormData> parsed = this.parseTask(form.getTaskId());
        String authUser = AuthContextUtils.getUsername();
        if (!((Task)parsed.getLeft()).getAssignee().equals(authUser)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Task " + form.getTaskId() + " assigned to " + ((Task)parsed.getLeft()).getAssignee() + " but submitted by " + authUser));
        }
        String procInstId = ((Task)parsed.getLeft()).getProcessInstanceId();
        User user = (User)this.userDAO.find(this.getUserKey(procInstId));
        if (user == null) {
            throw new NotFoundException("User with key " + this.getUserKey(procInstId));
        }
        Set<String> preTasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInstId, user);
        this.engine.getRuntimeService().setVariable(procInstId, "task", (Object)"submit");
        this.engine.getRuntimeService().setVariable(procInstId, "formSubmitter", (Object)authUser);
        this.engine.getRuntimeService().setVariable(procInstId, "user", (Object)this.lazyLoad(user));
        try {
            this.engine.getFormService().submitTaskFormData(form.getTaskId(), this.getPropertiesForSubmit(form));
        }
        catch (FlowableException e) {
            FlowableRuntimeUtils.throwException(e, "While submitting form for task " + form.getTaskId());
        }
        Set<String> postTasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInstId, user);
        postTasks.removeAll(preTasks);
        postTasks.add(form.getTaskId());
        if (procInstId.equals(FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey()))) {
            FlowableRuntimeUtils.updateStatus(this.engine, procInstId, user);
        }
        user = (User)this.userDAO.save((Any)user);
        UserPatch userPatch = null;
        String clearPassword = null;
        PropagationByResource propByRes = null;
        ProcessInstance afterSubmitPI = (ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstId).singleResult();
        if (afterSubmitPI != null) {
            this.engine.getRuntimeService().removeVariable(procInstId, "task");
            this.engine.getRuntimeService().removeVariable(procInstId, "formSubmitter");
            this.engine.getRuntimeService().removeVariable(procInstId, "user");
            this.engine.getRuntimeService().removeVariable(procInstId, "userTO");
            propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstId, "propByResource", PropagationByResource.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "propByResource");
            String encryptedPwd = (String)this.engine.getRuntimeService().getVariable(procInstId, "encryptedPwd", String.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "encryptedPwd");
            if (StringUtils.isNotBlank((CharSequence)encryptedPwd)) {
                clearPassword = FlowableRuntimeUtils.decrypt(encryptedPwd);
            }
            Boolean enabled = (Boolean)this.engine.getRuntimeService().getVariable(procInstId, "enabled", Boolean.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "enabled");
            FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInstId, user, this.dataBinder.getUserTO(user, true), clearPassword, enabled, propByRes);
            userPatch = (UserPatch)this.engine.getRuntimeService().getVariable(procInstId, "userPatch", UserPatch.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "userPatch");
        }
        if (userPatch == null) {
            userPatch = new UserPatch();
            userPatch.setKey(user.getKey());
            userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).value(clearPassword)).build());
            if (propByRes != null) {
                userPatch.getPassword().getResources().addAll(propByRes.get(ResourceOperation.CREATE));
            }
        }
        return new WorkflowResult((Object)userPatch, propByRes, postTasks);
    }
}

