/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.syncope.common.lib.types.BpmnProcessFormat;
import org.apache.syncope.core.flowable.api.BpmnProcessManager;
import org.apache.syncope.core.flowable.impl.FlowableDeployUtils;
import org.apache.syncope.core.flowable.impl.FlowableRuntimeUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.flowable.support.DropdownAwareJsonConverter;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.Model;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public class FlowableBpmnProcessManager
implements BpmnProcessManager {
    protected static final Logger LOG = LoggerFactory.getLogger(BpmnProcessManager.class);
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final String MODEL_DATA_JSON_MODEL = "model";
    @Autowired
    protected DomainProcessEngine engine;

    protected Model getModel(ProcessDefinition procDef) {
        try {
            Model model = (Model)this.engine.getRepositoryService().createModelQuery().deploymentId(procDef.getDeploymentId()).singleResult();
            if (model == null) {
                throw new NotFoundException("Could not find Model for deployment " + procDef.getDeploymentId());
            }
            return model;
        }
        catch (Exception e) {
            throw new WorkflowException("While accessing process " + procDef.getKey(), (Throwable)e);
        }
    }

    @Override
    public List<BpmnProcess> getProcesses() {
        try {
            return this.engine.getRepositoryService().createProcessDefinitionQuery().latestVersion().list().stream().map(procDef -> {
                BpmnProcess defTO = new BpmnProcess();
                defTO.setKey(procDef.getKey());
                defTO.setName(procDef.getName());
                try {
                    defTO.setModelId(this.getModel((ProcessDefinition)procDef).getId());
                }
                catch (NotFoundException e) {
                    LOG.warn("No model found for definition {}, ignoring", (Object)procDef.getDeploymentId(), (Object)e);
                }
                defTO.setUserWorkflow("userWorkflow".equals(procDef.getKey()));
                return defTO;
            }).collect(Collectors.toList());
        }
        catch (FlowableException e) {
            throw new WorkflowException("While listing available process definitions", (Throwable)e);
        }
    }

    protected void exportProcessModel(String key, OutputStream os) {
        Model model = this.getModel(FlowableRuntimeUtils.getLatestProcDefByKey(this.engine, key));
        try {
            ObjectNode modelNode = (ObjectNode)OBJECT_MAPPER.readTree(model.getMetaInfo());
            modelNode.put("modelId", model.getId());
            modelNode.replace(MODEL_DATA_JSON_MODEL, OBJECT_MAPPER.readTree(this.engine.getRepositoryService().getModelEditorSource(model.getId())));
            os.write(modelNode.toString().getBytes());
        }
        catch (IOException e) {
            LOG.error("While exporting workflow definition {}", (Object)model.getId(), (Object)e);
        }
    }

    protected void exportProcessResource(String deploymentId, String resourceName, OutputStream os) {
        try (InputStream procDefIS = this.engine.getRepositoryService().getResourceAsStream(deploymentId, resourceName);){
            IOUtils.copy((InputStream)procDefIS, (OutputStream)os);
        }
        catch (IOException e) {
            LOG.error("While exporting {}", (Object)resourceName, (Object)e);
        }
    }

    @Override
    public void exportProcess(String key, BpmnProcessFormat format, OutputStream os) {
        switch (format) {
            case JSON: {
                this.exportProcessModel(key, os);
                break;
            }
            default: {
                ProcessDefinition procDef = FlowableRuntimeUtils.getLatestProcDefByKey(this.engine, key);
                if (procDef == null) {
                    throw new NotFoundException("Process Definition " + key);
                }
                this.exportProcessResource(procDef.getDeploymentId(), procDef.getResourceName(), os);
            }
        }
    }

    @Override
    public void exportDiagram(String key, OutputStream os) {
        ProcessDefinition procDef = FlowableRuntimeUtils.getLatestProcDefByKey(this.engine, key);
        if (procDef == null) {
            throw new NotFoundException("Workflow process definition for " + key);
        }
        this.exportProcessResource(procDef.getDeploymentId(), procDef.getDiagramResourceName(), os);
    }

    @Override
    public void importProcess(String key, BpmnProcessFormat format, String definition) {
        Deployment deployment;
        ProcessDefinition procDef = FlowableRuntimeUtils.getLatestProcDefByKey(this.engine, key);
        String resourceName = procDef == null ? key + ".bpmn20.xml" : procDef.getResourceName();
        switch (format) {
            case JSON: {
                try {
                    JsonNode definitionNode = OBJECT_MAPPER.readTree(definition);
                    if (definitionNode.has(MODEL_DATA_JSON_MODEL)) {
                        definitionNode = definitionNode.get(MODEL_DATA_JSON_MODEL);
                    }
                    if (!definitionNode.has("childShapes")) {
                        throw new IllegalArgumentException("Could not find JSON node childShapes");
                    }
                    BpmnModel bpmnModel = new DropdownAwareJsonConverter().convertToBpmnModel(definitionNode);
                    deployment = FlowableDeployUtils.deployDefinition(this.engine, resourceName, new BpmnXMLConverter().convertToXML(bpmnModel));
                    break;
                }
                catch (Exception e) {
                    throw new WorkflowException("While creating or updating process " + key, (Throwable)e);
                }
            }
            default: {
                deployment = FlowableDeployUtils.deployDefinition(this.engine, resourceName, definition.getBytes());
            }
        }
        try {
            procDef = (ProcessDefinition)this.engine.getRepositoryService().createProcessDefinitionQuery().deploymentId(deployment.getId()).latestVersion().singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While accessing deployment " + deployment.getId(), (Throwable)e);
        }
        if (!key.equals(procDef.getKey())) {
            throw new WorkflowException("Mismatching key: expected " + key + ", found " + procDef.getKey());
        }
        FlowableDeployUtils.deployModel(this.engine, procDef);
    }

    @Override
    public void deleteProcess(String key) {
        if ("userWorkflow".equals(key)) {
            throw new WorkflowException("Cannot delete the main process userWorkflow");
        }
        try {
            this.engine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(key).list().forEach(procDef -> {
                this.engine.getRepositoryService().deleteModel(this.getModel((ProcessDefinition)procDef).getId());
                this.engine.getRepositoryService().deleteDeployment(procDef.getDeploymentId(), true);
            });
        }
        catch (Exception e) {
            throw new WorkflowException("While deleting process " + key, (Throwable)e);
        }
    }
}

