/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui;

import com.googlecode.wicket.kendo.ui.KendoCulture;
import com.googlecode.wicket.kendo.ui.resource.KendoCultureResourceReference;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;

public class KendoCultureHeaderItem
extends JavaScriptContentHeaderItem {
    private static final long serialVersionUID = 1L;
    private final String culture;

    public KendoCultureHeaderItem(Locale locale) {
        this(locale.toLanguageTag());
    }

    public KendoCultureHeaderItem(KendoCulture culture) {
        this(culture.toString());
    }

    public KendoCultureHeaderItem(String culture) {
        super((CharSequence)String.format("kendo.culture('%s');", culture), "kendo-culture", null);
        this.culture = culture;
    }

    public List<HeaderItem> getDependencies() {
        List dependencies = super.getDependencies();
        dependencies.add(JavaScriptHeaderItem.forReference((ResourceReference)new KendoCultureResourceReference(this.culture)));
        return dependencies;
    }

    public static HeaderItem of(Locale locale) {
        if (locale != null) {
            return KendoCultureHeaderItem.of(locale.toLanguageTag(), locale.getLanguage());
        }
        return null;
    }

    public static HeaderItem of(String ... cultures) {
        String culture = KendoCulture.get(cultures);
        if (culture != null) {
            return new PriorityHeaderItem((HeaderItem)new KendoCultureHeaderItem(culture));
        }
        return null;
    }
}

