/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.SAML2EntityFactory;
import org.apache.syncope.core.persistence.api.entity.SAML2IdP;
import org.apache.syncope.core.persistence.api.entity.SAML2IdPItem;
import org.apache.syncope.core.persistence.api.entity.SAML2UserTemplate;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPASAML2IdP;
import org.apache.syncope.core.persistence.jpa.entity.JPASAML2IdPItem;
import org.apache.syncope.core.persistence.jpa.entity.JPASAML2UserTemplate;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.springframework.stereotype.Component;

@Component
public class JPASAML2EntityFactory
implements SAML2EntityFactory {
    public <E extends Entity> E newEntity(Class<E> reference) {
        PersistenceCapable result;
        if (reference.equals(SAML2IdP.class)) {
            result = new JPASAML2IdP();
        } else if (reference.equals(SAML2IdPItem.class)) {
            result = new JPASAML2IdPItem();
        } else if (reference.equals(SAML2UserTemplate.class)) {
            result = new JPASAML2UserTemplate();
        } else {
            throw new IllegalArgumentException("Could not find a JPA implementation of " + reference.getName());
        }
        if (result instanceof AbstractGeneratedKeyEntity) {
            ((AbstractGeneratedKeyEntity)result).setKey(SecureRandomUtils.generateRandomUUID().toString());
        }
        return (E)result;
    }
}

