/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.syncope.common.rest.api.beans.RemediationQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Remediations")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="remediations")
public interface RemediationService
extends JAXRSService {
    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<RemediationTO> list(@BeanParam RemediationQuery var1);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public RemediationTO read(@NotNull @PathParam(value="key") String var1);

    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response delete(@NotNull @PathParam(value="key") String var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="key", description="Entity's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Object successfully created enriched with propagation status information, as Entity,or empty if 'Prefer: return-no-content' was specified", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}, headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the object created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the object created"), @Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Path(value="{remediationKey}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response remedy(@NotNull @PathParam(value="remediationKey") String var1, @NotNull AnyTO var2);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="key", description="Entity's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Object successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @PATCH
    @Path(value="{remediationKey}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response remedy(@NotNull @PathParam(value="remediationKey") String var1, @NotNull AnyPatch var2);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Object successfully deleted enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @DELETE
    @Path(value="{remediationKey}/{anyKey}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response remedy(@NotNull @PathParam(value="remediationKey") String var1, @NotNull @PathParam(value="anyKey") String var2);
}

