/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.child.InParameterParser;
import org.flowable.bpmn.converter.child.OutParameterParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;

public class CallActivityXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();

    public CallActivityXMLConverter() {
        InParameterParser inParameterParser = new InParameterParser();
        this.childParserMap.put(inParameterParser.getElementName(), inParameterParser);
        OutParameterParser outParameterParser = new OutParameterParser();
        this.childParserMap.put(outParameterParser.getElementName(), outParameterParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return CallActivity.class;
    }

    @Override
    protected String getXMLElementName() {
        return "callActivity";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        CallActivity callActivity = new CallActivity();
        BpmnXMLUtil.addXMLLocation((BaseElement)callActivity, xtr);
        callActivity.setCalledElement(xtr.getAttributeValue(null, "calledElement"));
        callActivity.setCalledElementType(BpmnXMLUtil.getAttributeValue("calledElementType", xtr));
        callActivity.setProcessInstanceName(BpmnXMLUtil.getAttributeValue("processInstanceName", xtr));
        callActivity.setBusinessKey(BpmnXMLUtil.getAttributeValue("businessKey", xtr));
        callActivity.setInheritBusinessKey(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("inheritBusinessKey", xtr)));
        callActivity.setInheritVariables(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("inheritVariables", xtr)).booleanValue());
        callActivity.setSameDeployment(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("sameDeployment", xtr)).booleanValue());
        callActivity.setUseLocalScopeForOutParameters(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("useLocalScopeForOutParameters", xtr)).booleanValue());
        callActivity.setCompleteAsync(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("completeAsync", xtr)).booleanValue());
        String fallbackToDefaultTenant = BpmnXMLUtil.getAttributeValue("fallbackToDefaultTenant", xtr);
        if (StringUtils.isNotEmpty((CharSequence)fallbackToDefaultTenant)) {
            callActivity.setFallbackToDefaultTenant(Boolean.valueOf(fallbackToDefaultTenant));
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)callActivity, this.childParserMap, model, xtr);
        return callActivity;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            xtw.writeAttribute("calledElement", callActivity.getCalledElement());
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElementType())) {
            this.writeQualifiedAttribute("calledElementType", callActivity.getCalledElementType(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getProcessInstanceName())) {
            this.writeQualifiedAttribute("processInstanceName", callActivity.getProcessInstanceName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getBusinessKey())) {
            this.writeQualifiedAttribute("businessKey", callActivity.getBusinessKey(), xtw);
        }
        if (callActivity.isInheritBusinessKey()) {
            this.writeQualifiedAttribute("inheritBusinessKey", "true", xtw);
        }
        if (callActivity.isUseLocalScopeForOutParameters()) {
            this.writeQualifiedAttribute("useLocalScopeForOutParameters", "true", xtw);
        }
        if (callActivity.isInheritVariables()) {
            this.writeQualifiedAttribute("inheritVariables", "true", xtw);
        }
        if (callActivity.isSameDeployment()) {
            this.writeQualifiedAttribute("sameDeployment", "true", xtw);
        }
        if (callActivity.isCompleteAsync()) {
            this.writeQualifiedAttribute("completeAsync", "true", xtw);
        }
        if (callActivity.getFallbackToDefaultTenant() != null) {
            this.writeQualifiedAttribute("fallbackToDefaultTenant", callActivity.getFallbackToDefaultTenant().toString(), xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        CallActivity callActivity = (CallActivity)element;
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("in", callActivity.getInParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("out", callActivity.getOutParameters(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

