/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.info.JavaImplInfo;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.logic.AbstractLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.event.EventListener;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class SyncopeLogic
extends AbstractLogic<EntityTO> {
    private static final Object MONITOR = new Object();
    private static PlatformInfo PLATFORM_INFO;
    private static SystemInfo SYSTEM_INFO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private SecurityQuestionDAO securityQuestionDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private GroupDataBinder groupDataBinder;
    @Resource(name="version")
    private String version;
    @Resource(name="buildNumber")
    private String buildNumber;
    @Autowired
    private ConnIdBundleManager bundleManager;
    @Autowired
    private PropagationTaskExecutor propagationTaskExecutor;
    @Autowired
    private AnyObjectWorkflowAdapter awfAdapter;
    @Autowired
    private UserWorkflowAdapter uwfAdapter;
    @Autowired
    private GroupWorkflowAdapter gwfAdapter;
    @Autowired
    private AnyObjectProvisioningManager aProvisioningManager;
    @Autowired
    private UserProvisioningManager uProvisioningManager;
    @Autowired
    private GroupProvisioningManager gProvisioningManager;
    @Autowired
    private VirAttrCache virAttrCache;
    @Autowired
    private PasswordGenerator passwordGenerator;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private PlainAttrDAO plainAttrDAO;
    @Autowired
    private PlainAttrValueDAO plainAttrValueDAO;
    @Autowired
    private AnySearchDAO anySearchDAO;
    @Autowired
    private ImplementationLookup implLookup;

    public boolean isSelfRegAllowed() {
        return (Boolean)this.confDAO.find("selfRegistration.allowed", (Object)false);
    }

    public boolean isPwdResetAllowed() {
        return (Boolean)this.confDAO.find("passwordReset.allowed", (Object)false);
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return (Boolean)this.confDAO.find("passwordReset.securityQuestion", (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public PlatformInfo platform() {
        Object object = MONITOR;
        synchronized (object) {
            if (PLATFORM_INFO == null) {
                PLATFORM_INFO = new PlatformInfo();
                PLATFORM_INFO.setVersion(this.version);
                PLATFORM_INFO.setBuildNumber(this.buildNumber);
                if (this.bundleManager.getLocations() != null) {
                    PLATFORM_INFO.getConnIdLocations().addAll(this.bundleManager.getLocations().stream().map(URI::toASCIIString).collect(Collectors.toList()));
                }
                PLATFORM_INFO.getWorkflowInfo().setAnyObjectWorkflowAdapter(AopUtils.getTargetClass((Object)this.awfAdapter).getName());
                PLATFORM_INFO.getWorkflowInfo().setUserWorkflowAdapter(AopUtils.getTargetClass((Object)this.uwfAdapter).getName());
                PLATFORM_INFO.getWorkflowInfo().setGroupWorkflowAdapter(AopUtils.getTargetClass((Object)this.gwfAdapter).getName());
                PLATFORM_INFO.getProvisioningInfo().setAnyObjectProvisioningManager(AopUtils.getTargetClass((Object)this.aProvisioningManager).getName());
                PLATFORM_INFO.getProvisioningInfo().setUserProvisioningManager(AopUtils.getTargetClass((Object)this.uProvisioningManager).getName());
                PLATFORM_INFO.getProvisioningInfo().setGroupProvisioningManager(AopUtils.getTargetClass((Object)this.gProvisioningManager).getName());
                PLATFORM_INFO.getProvisioningInfo().setPropagationTaskExecutor(AopUtils.getTargetClass((Object)this.propagationTaskExecutor).getName());
                PLATFORM_INFO.getProvisioningInfo().setVirAttrCache(AopUtils.getTargetClass((Object)this.virAttrCache).getName());
                PLATFORM_INFO.setPasswordGenerator(AopUtils.getTargetClass((Object)this.passwordGenerator).getName());
                PLATFORM_INFO.getPersistenceInfo().setEntityFactory(AopUtils.getTargetClass((Object)this.entityFactory).getName());
                PLATFORM_INFO.getPersistenceInfo().setPlainSchemaDAO(AopUtils.getTargetClass((Object)this.plainSchemaDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setPlainAttrDAO(AopUtils.getTargetClass((Object)this.plainAttrDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setPlainAttrValueDAO(AopUtils.getTargetClass((Object)this.plainAttrValueDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setAnySearchDAO(AopUtils.getTargetClass((Object)this.anySearchDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setUserDAO(AopUtils.getTargetClass((Object)this.userDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setGroupDAO(AopUtils.getTargetClass((Object)this.groupDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setAnyObjectDAO(AopUtils.getTargetClass((Object)this.anyObjectDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setConfDAO(AopUtils.getTargetClass((Object)this.confDAO).getName());
                Arrays.stream(ImplementationType.values()).forEach(type -> {
                    JavaImplInfo javaImplInfo = new JavaImplInfo();
                    javaImplInfo.setType(type);
                    javaImplInfo.getClasses().addAll(this.implLookup.getClassNames(type));
                    PLATFORM_INFO.getJavaImplInfos().add(javaImplInfo);
                });
            }
            PLATFORM_INFO.setSelfRegAllowed(this.isSelfRegAllowed());
            PLATFORM_INFO.setPwdResetAllowed(this.isPwdResetAllowed());
            PLATFORM_INFO.setPwdResetRequiringSecurityQuestions(this.isPwdResetRequiringSecurityQuestions());
            PLATFORM_INFO.getEntitlements().clear();
            PLATFORM_INFO.getEntitlements().addAll(EntitlementsHolder.getInstance().getValues());
            AuthContextUtils.execWithAuthContext((String)AuthContextUtils.getDomain(), () -> {
                PLATFORM_INFO.getAnyTypes().clear();
                PLATFORM_INFO.getAnyTypes().addAll(this.anyTypeDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getUserClasses().clear();
                PLATFORM_INFO.getUserClasses().addAll(this.anyTypeDAO.findUser().getClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getAnyTypeClasses().clear();
                PLATFORM_INFO.getAnyTypeClasses().addAll(this.anyTypeClassDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getResources().clear();
                PLATFORM_INFO.getResources().addAll(this.resourceDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                return null;
            });
        }
        return PLATFORM_INFO;
    }

    private void initSystemInfo() {
        if (SYSTEM_INFO == null) {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            SYSTEM_INFO = new SystemInfo();
            try {
                SYSTEM_INFO.setHostname(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                LOG.error("Could not get host name", (Throwable)e);
            }
            SYSTEM_INFO.setOs(operatingSystemMXBean.getName() + " " + operatingSystemMXBean.getVersion() + " " + operatingSystemMXBean.getArch());
            SYSTEM_INFO.setAvailableProcessors(operatingSystemMXBean.getAvailableProcessors());
            SYSTEM_INFO.setJvm(runtimeMXBean.getVmName() + " " + System.getProperty("java.version") + " " + runtimeMXBean.getVmVendor());
            SYSTEM_INFO.setStartTime(runtimeMXBean.getStartTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void addLoadInstant(PayloadApplicationEvent<SystemInfo.LoadInstant> event) {
        Object object = MONITOR;
        synchronized (object) {
            this.initSystemInfo();
            SYSTEM_INFO.getLoad().add(event.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="isAuthenticated()")
    public SystemInfo system() {
        Object object = MONITOR;
        synchronized (object) {
            this.initSystemInfo();
        }
        return SYSTEM_INFO;
    }

    @PreAuthorize(value="isAuthenticated()")
    public NumbersInfo numbers() {
        NumbersInfo numbersInfo = new NumbersInfo();
        numbersInfo.setTotalUsers(this.userDAO.count());
        numbersInfo.getUsersByRealm().putAll(this.userDAO.countByRealm());
        numbersInfo.getUsersByStatus().putAll(this.userDAO.countByStatus());
        numbersInfo.setTotalGroups(this.groupDAO.count());
        numbersInfo.getGroupsByRealm().putAll(this.groupDAO.countByRealm());
        Map anyObjectNumbers = this.anyObjectDAO.countByType();
        Iterator itor = anyObjectNumbers.entrySet().iterator();
        for (int i = 0; i < 2 && itor.hasNext(); ++i) {
            Map.Entry entry = itor.next();
            if (i == 0) {
                numbersInfo.setAnyType1(((AnyType)entry.getKey()).getKey());
                numbersInfo.setTotalAny1((Integer)entry.getValue());
                numbersInfo.getAny1ByRealm().putAll(this.anyObjectDAO.countByRealm((AnyType)entry.getKey()));
                continue;
            }
            if (i != 1) continue;
            numbersInfo.setAnyType2(((AnyType)entry.getKey()).getKey());
            numbersInfo.setTotalAny2((Integer)entry.getValue());
            numbersInfo.getAny2ByRealm().putAll(this.anyObjectDAO.countByRealm((AnyType)entry.getKey()));
        }
        numbersInfo.setTotalResources(this.resourceDAO.count());
        numbersInfo.setTotalRoles(this.roleDAO.count());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.RESOURCE.name(), numbersInfo.getTotalResources() > 0);
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ACCOUNT_POLICY.name(), !this.policyDAO.find(AccountPolicy.class).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.PASSWORD_POLICY.name(), !this.policyDAO.find(PasswordPolicy.class).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.NOTIFICATION.name(), !this.notificationDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.PULL_TASK.name(), !this.taskDAO.findAll(TaskType.PULL).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.VIR_SCHEMA.name(), !this.virSchemaDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ANY_TYPE.name(), !anyObjectNumbers.isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.SECURITY_QUESTION.name(), !this.securityQuestionDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ROLE.name(), numbersInfo.getTotalRoles() > 0);
        return numbersInfo;
    }

    @PreAuthorize(value="isAuthenticated()")
    public Pair<Integer, List<GroupTO>> searchAssignableGroups(String realm, String term, int page, int size) {
        SearchCond searchCond;
        AssignableCond assignableCond = new AssignableCond();
        assignableCond.setRealmFullPath(realm);
        if (StringUtils.isNotBlank((CharSequence)term)) {
            AnyCond termCond = new AnyCond(AttributeCond.Type.ILIKE);
            termCond.setSchema("name");
            String termSearchableValue = term.startsWith("*") && !term.endsWith("*") ? term + "%" : (!term.startsWith("*") && term.endsWith("*") ? "%" + term : (term.startsWith("*") && term.endsWith("*") ? term : "%" + term + "%"));
            termCond.setExpression(termSearchableValue);
            searchCond = SearchCond.getAndCond((SearchCond)SearchCond.getLeafCond((AssignableCond)assignableCond), (SearchCond)SearchCond.getLeafCond((AttributeCond)termCond));
        } else {
            searchCond = SearchCond.getLeafCond((AssignableCond)assignableCond);
        }
        int count = this.searchDAO.count(SyncopeConstants.FULL_ADMIN_REALMS, searchCond, AnyTypeKind.GROUP);
        OrderByClause orderByClause = new OrderByClause();
        orderByClause.setField("name");
        orderByClause.setDirection(OrderByClause.Direction.ASC);
        List matching = this.searchDAO.search(SyncopeConstants.FULL_ADMIN_REALMS, searchCond, page, size, Collections.singletonList(orderByClause), AnyTypeKind.GROUP);
        List result = matching.stream().map(group -> this.groupDataBinder.getGroupTO(group, false)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @PreAuthorize(value="isAuthenticated()")
    public TypeExtensionTO readTypeExtension(String groupName) {
        Group group = this.groupDAO.findByName(groupName);
        if (group == null) {
            throw new NotFoundException("Group " + groupName);
        }
        Optional typeExt = group.getTypeExtension(this.anyTypeDAO.findUser());
        if (!typeExt.isPresent()) {
            throw new NotFoundException("TypeExtension in " + groupName + " for users");
        }
        return this.groupDataBinder.getTypeExtensionTO((TypeExtension)typeExt.get());
    }

    @Override
    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

