/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.provisioning.api.data.DynRealmDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DynRealmLogic
extends AbstractTransactionalLogic<DynRealmTO> {
    @Autowired
    private DynRealmDataBinder binder;
    @Autowired
    private DynRealmDAO dynRealmDAO;

    @PreAuthorize(value="hasRole('DYNREALM_READ')")
    @Transactional(readOnly=true)
    public DynRealmTO read(String key) {
        DynRealm dynRealm = this.dynRealmDAO.find(key);
        if (dynRealm == null) {
            LOG.error("Could not find dynamic realm '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.binder.getDynRealmTO(dynRealm);
    }

    @Transactional(readOnly=true)
    public List<DynRealmTO> list() {
        return this.dynRealmDAO.findAll().stream().map(arg_0 -> ((DynRealmDataBinder)this.binder).getDynRealmTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('DYNREALM_CREATE')")
    public DynRealmTO create(DynRealmTO dynRealmTO) {
        return this.binder.getDynRealmTO(this.binder.create(dynRealmTO));
    }

    @PreAuthorize(value="hasRole('DYNREALM_UPDATE')")
    public DynRealmTO update(DynRealmTO dynRealmTO) {
        DynRealm dynRealm = this.dynRealmDAO.find(dynRealmTO.getKey());
        if (dynRealm == null) {
            LOG.error("Could not find dynamic realm '" + dynRealmTO.getKey() + "'");
            throw new NotFoundException(dynRealmTO.getKey());
        }
        return this.binder.getDynRealmTO(this.binder.update(dynRealm, dynRealmTO));
    }

    @PreAuthorize(value="hasRole('DYNREALM_DELETE')")
    public DynRealmTO delete(String key) {
        DynRealm dynRealm = this.dynRealmDAO.find(key);
        if (dynRealm == null) {
            LOG.error("Could not find dynamic realm '" + key + "'");
            throw new NotFoundException(key);
        }
        DynRealmTO deleted = this.binder.getDynRealmTO(dynRealm);
        this.dynRealmDAO.delete(key);
        return deleted;
    }

    @Override
    protected DynRealmTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof DynRealmTO)) continue;
                key = ((DynRealmTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getDynRealmTO(this.dynRealmDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

