/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnIdObjectClassTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConnectorLogic
extends AbstractTransactionalLogic<ConnInstanceTO> {
    @Autowired
    private ConnIdBundleManager connIdBundleManager;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private ConnInstanceDataBinder binder;
    @Autowired
    private ConnectorFactory connFactory;

    protected void securityChecks(Set<String> effectiveRealms, String realm, String key) {
        boolean authorized = effectiveRealms.stream().anyMatch(ownedRealm -> realm.startsWith((String)ownedRealm));
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, ConnInstance.class.getSimpleName(), key);
        }
    }

    @PreAuthorize(value="hasRole('CONNECTOR_CREATE')")
    public ConnInstanceTO create(ConnInstanceTO connInstanceTO) {
        if (connInstanceTO.getAdminRealm() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_CREATE")), (String)connInstanceTO.getAdminRealm());
        this.securityChecks(effectiveRealms, connInstanceTO.getAdminRealm(), null);
        return this.binder.getConnInstanceTO(this.connInstanceDAO.save(this.binder.getConnInstance(connInstanceTO)));
    }

    @PreAuthorize(value="hasRole('CONNECTOR_UPDATE')")
    public ConnInstanceTO update(ConnInstanceTO connInstanceTO) {
        if (connInstanceTO.getAdminRealm() == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidConnInstance);
            sce.getElements().add("Invalid or null realm specified: " + connInstanceTO.getAdminRealm());
            throw sce;
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_UPDATE")), (String)connInstanceTO.getAdminRealm());
        this.securityChecks(effectiveRealms, connInstanceTO.getAdminRealm(), connInstanceTO.getKey());
        return this.binder.getConnInstanceTO(this.binder.update(connInstanceTO));
    }

    @PreAuthorize(value="hasRole('CONNECTOR_DELETE')")
    public ConnInstanceTO delete(String key) {
        ConnInstance connInstance = this.connInstanceDAO.authFind(key);
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + key + "'");
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_DELETE")), (String)connInstance.getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, connInstance.getAdminRealm().getFullPath(), connInstance.getKey());
        if (!connInstance.getResources().isEmpty()) {
            SyncopeClientException associatedResources = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.AssociatedResources);
            connInstance.getResources().forEach(resource -> associatedResources.getElements().add(resource.getKey()));
            throw associatedResources;
        }
        ConnInstanceTO deleted = this.binder.getConnInstanceTO(connInstance);
        this.connInstanceDAO.delete(key);
        return deleted;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_LIST')")
    @Transactional(readOnly=true)
    public List<ConnInstanceTO> list(String lang) {
        CurrentLocale.set((Locale)(StringUtils.isBlank((CharSequence)lang) ? Locale.ENGLISH : new Locale(lang)));
        return this.connInstanceDAO.findAll().stream().filter(connInstance -> connInstance != null).map(connInstance -> {
            ConnInstanceTO result = null;
            try {
                result = this.binder.getConnInstanceTO(connInstance);
            }
            catch (NotFoundException e) {
                LOG.error("Connector '{}#{}' not found", (Object)connInstance.getBundleName(), (Object)connInstance.getVersion());
            }
            return result;
        }).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @Transactional(readOnly=true)
    public ConnInstanceTO read(String key, String lang) {
        CurrentLocale.set((Locale)(StringUtils.isBlank((CharSequence)lang) ? Locale.ENGLISH : new Locale(lang)));
        ConnInstance connInstance = this.connInstanceDAO.authFind(key);
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + key + "'");
        }
        return this.binder.getConnInstanceTO(connInstance);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @Transactional(readOnly=true)
    public List<ConnBundleTO> getBundles(String lang) {
        if (StringUtils.isBlank((CharSequence)lang)) {
            CurrentLocale.set((Locale)Locale.ENGLISH);
        } else {
            CurrentLocale.set((Locale)new Locale(lang));
        }
        ArrayList<ConnBundleTO> connectorBundleTOs = new ArrayList<ConnBundleTO>();
        this.connIdBundleManager.getConnInfoManagers().forEach((uri, cim) -> connectorBundleTOs.addAll(cim.getConnectorInfos().stream().map(bundle -> {
            ConnBundleTO connBundleTO = new ConnBundleTO();
            connBundleTO.setDisplayName(bundle.getConnectorDisplayName());
            connBundleTO.setLocation(uri.toString());
            ConnectorKey key = bundle.getConnectorKey();
            connBundleTO.setBundleName(key.getBundleName());
            connBundleTO.setConnectorName(key.getConnectorName());
            connBundleTO.setVersion(key.getBundleVersion());
            ConfigurationProperties properties = this.connIdBundleManager.getConfigurationProperties(bundle);
            connBundleTO.getProperties().addAll(properties.getPropertyNames().stream().map(propName -> this.binder.build(properties.getProperty(propName))).collect(Collectors.toList()));
            return connBundleTO;
        }).collect(Collectors.toList())));
        return connectorBundleTOs;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    public List<ConnIdObjectClassTO> buildObjectClassInfo(ConnInstanceTO connInstanceTO, boolean includeSpecial) {
        ConnInstanceTO actual = connInstanceTO;
        ConnInstance existing = this.connInstanceDAO.find(connInstanceTO.getKey());
        if (existing != null) {
            actual = this.binder.getConnInstanceTO(existing);
        }
        Set objectClassInfo = this.connFactory.createConnector(this.connFactory.buildConnInstanceOverride(actual, (Collection)connInstanceTO.getConf(), null)).getObjectClassInfo();
        return objectClassInfo.stream().map(info -> {
            ConnIdObjectClassTO connIdObjectClassTO = new ConnIdObjectClassTO();
            connIdObjectClassTO.setType(info.getType());
            connIdObjectClassTO.setAuxiliary(info.isAuxiliary());
            connIdObjectClassTO.setContainer(info.isContainer());
            connIdObjectClassTO.getAttributes().addAll(info.getAttributeInfo().stream().filter(attrInfo -> includeSpecial || !AttributeUtil.isSpecialName((String)attrInfo.getName())).map(AttributeInfo::getName).collect(Collectors.toList()));
            return connIdObjectClassTO;
        }).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @Transactional(readOnly=true)
    public void check(ConnInstanceTO connInstanceTO) {
        if (connInstanceTO.getAdminRealm() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
        }
        this.connFactory.createConnector(this.binder.getConnInstance(connInstanceTO)).test();
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @Transactional(readOnly=true)
    public ConnInstanceTO readByResource(String resourceName, String lang) {
        CurrentLocale.set((Locale)(StringUtils.isBlank((CharSequence)lang) ? Locale.ENGLISH : new Locale(lang)));
        ExternalResource resource = this.resourceDAO.find(resourceName);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceName + "'");
        }
        ConnInstanceTO connInstance = this.binder.getConnInstanceTO(this.connFactory.getConnector(resource).getConnInstance());
        connInstance.setKey(resource.getConnector().getKey());
        return connInstance;
    }

    @PreAuthorize(value="hasRole('CONNECTOR_RELOAD')")
    @Transactional(readOnly=true)
    public void reload() {
        this.connFactory.unload();
        this.connFactory.load();
    }

    @Override
    protected ConnInstanceTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ConnInstanceTO)) continue;
                key = ((ConnInstanceTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getConnInstanceTO(this.connInstanceDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

