/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.LogicActions;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AnyObjectLogic
extends AbstractAnyLogic<AnyObjectTO, AnyObjectPatch> {
    @Autowired
    protected AnySearchDAO searchDAO;
    @Autowired
    protected AnyObjectDataBinder binder;
    @Autowired
    protected AnyObjectProvisioningManager provisioningManager;

    @Override
    @Transactional(readOnly=true)
    public AnyObjectTO read(String key) {
        return this.binder.getAnyObjectTO(key);
    }

    @Override
    @Transactional(readOnly=true)
    public Pair<Integer, List<AnyObjectTO>> search(SearchCond searchCond, int page, int size, List<OrderByClause> orderBy, String realm, boolean details) {
        if (searchCond.hasAnyTypeCond() == null) {
            throw new UnsupportedOperationException("Need to specify " + AnyType.class.getSimpleName());
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.SEARCH.getFor(searchCond.hasAnyTypeCond()))), (String)realm);
        int count = this.searchDAO.count(effectiveRealms, searchCond, AnyTypeKind.ANY_OBJECT);
        List matching = this.searchDAO.search(effectiveRealms, searchCond, page, size, orderBy, AnyTypeKind.ANY_OBJECT);
        List result = matching.stream().map(anyObject -> this.binder.getAnyObjectTO(anyObject, details)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    public ProvisioningResult<AnyObjectTO> create(AnyObjectTO anyObjectTO, boolean nullPriorityAsync) {
        Pair<AnyObjectTO, List<LogicActions>> before = this.beforeCreate(anyObjectTO);
        if (((AnyObjectTO)before.getLeft()).getRealm() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
        }
        if (((AnyObjectTO)before.getLeft()).getType() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.CREATE.getFor(((AnyObjectTO)before.getLeft()).getType()))), (String)((AnyObjectTO)before.getLeft()).getRealm());
        this.securityChecks(effectiveRealms, ((AnyObjectTO)before.getLeft()).getRealm(), null);
        Pair created = this.provisioningManager.create((AnyTO)before.getLeft(), nullPriorityAsync);
        return this.afterCreate(this.binder.getAnyObjectTO((String)created.getKey()), (List)created.getRight(), (List)before.getRight());
    }

    @Override
    public ProvisioningResult<AnyObjectTO> update(AnyObjectPatch anyObjectPatch, boolean nullPriorityAsync) {
        AnyObjectTO anyObjectTO = this.binder.getAnyObjectTO(anyObjectPatch.getKey());
        HashSet<String> dynRealmsBefore = new HashSet<String>(anyObjectTO.getDynRealms());
        Pair<AnyObjectPatch, List<LogicActions>> before = this.beforeUpdate(anyObjectPatch, anyObjectTO.getRealm());
        String realm = ((AnyObjectPatch)before.getLeft()).getRealm() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)((AnyObjectPatch)before.getLeft()).getRealm().getValue())) ? (String)((AnyObjectPatch)before.getLeft()).getRealm().getValue() : anyObjectTO.getRealm();
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObjectTO.getType()))), (String)realm);
        boolean authDynRealms = this.securityChecks(effectiveRealms, realm, ((AnyObjectPatch)before.getLeft()).getKey());
        Pair updated = this.provisioningManager.update((AnyPatch)anyObjectPatch, nullPriorityAsync);
        return this.afterUpdate(this.binder.getAnyObjectTO(((AnyObjectPatch)updated.getLeft()).getKey()), (List)updated.getRight(), (List)before.getRight(), authDynRealms, dynRealmsBefore);
    }

    @Override
    public ProvisioningResult<AnyObjectTO> delete(String key, boolean nullPriorityAsync) {
        AnyObjectTO anyObject = this.binder.getAnyObjectTO(key);
        Pair<AnyObjectTO, List<LogicActions>> before = this.beforeDelete(anyObject);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.DELETE.getFor(((AnyObjectTO)before.getLeft()).getType()))), (String)((AnyObjectTO)before.getLeft()).getRealm());
        this.securityChecks(effectiveRealms, ((AnyObjectTO)before.getLeft()).getRealm(), ((AnyObjectTO)before.getLeft()).getKey());
        List statuses = this.provisioningManager.delete(((AnyObjectTO)before.getLeft()).getKey(), nullPriorityAsync);
        AnyObjectTO anyObjectTO = new AnyObjectTO();
        anyObjectTO.setKey(((AnyObjectTO)before.getLeft()).getKey());
        return this.afterDelete(anyObjectTO, statuses, (List)before.getRight());
    }

    @Override
    public AnyObjectTO unlink(String key, Collection<String> resources) {
        AnyObjectTO anyObjectTO = this.binder.getAnyObjectTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObjectTO.getType()))), (String)anyObjectTO.getRealm());
        this.securityChecks(effectiveRealms, anyObjectTO.getRealm(), anyObjectTO.getKey());
        AnyObjectPatch patch = new AnyObjectPatch();
        patch.setKey(key);
        patch.getResources().addAll(resources.stream().map(resource -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(resource)).build()).collect(Collectors.toList()));
        return this.binder.getAnyObjectTO(this.provisioningManager.unlink((AnyPatch)patch));
    }

    @Override
    public AnyObjectTO link(String key, Collection<String> resources) {
        AnyObjectTO anyObjectTO = this.binder.getAnyObjectTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObjectTO.getType()))), (String)anyObjectTO.getRealm());
        this.securityChecks(effectiveRealms, anyObjectTO.getRealm(), anyObjectTO.getKey());
        AnyObjectPatch patch = new AnyObjectPatch();
        patch.setKey(key);
        patch.getResources().addAll(resources.stream().map(resource -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(resource)).build()).collect(Collectors.toList()));
        return this.binder.getAnyObjectTO(this.provisioningManager.link((AnyPatch)patch));
    }

    @Override
    public ProvisioningResult<AnyObjectTO> unassign(String key, Collection<String> resources, boolean nullPriorityAsync) {
        AnyObjectTO anyObjectTO = this.binder.getAnyObjectTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObjectTO.getType()))), (String)anyObjectTO.getRealm());
        this.securityChecks(effectiveRealms, anyObjectTO.getRealm(), anyObjectTO.getKey());
        AnyObjectPatch patch = new AnyObjectPatch();
        patch.setKey(key);
        patch.getResources().addAll(resources.stream().map(resource -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(resource)).build()).collect(Collectors.toList()));
        return this.update(patch, nullPriorityAsync);
    }

    @Override
    public ProvisioningResult<AnyObjectTO> assign(String key, Collection<String> resources, boolean changepwd, String password, boolean nullPriorityAsync) {
        AnyObjectTO anyObjectTO = this.binder.getAnyObjectTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObjectTO.getType()))), (String)anyObjectTO.getRealm());
        this.securityChecks(effectiveRealms, anyObjectTO.getRealm(), anyObjectTO.getKey());
        AnyObjectPatch patch = new AnyObjectPatch();
        patch.setKey(key);
        patch.getResources().addAll(resources.stream().map(resource -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(resource)).build()).collect(Collectors.toList()));
        return this.update(patch, nullPriorityAsync);
    }

    @Override
    public ProvisioningResult<AnyObjectTO> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        AnyObjectTO anyObjectTO = this.binder.getAnyObjectTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObjectTO.getType()))), (String)anyObjectTO.getRealm());
        this.securityChecks(effectiveRealms, anyObjectTO.getRealm(), anyObjectTO.getKey());
        List statuses = this.provisioningManager.deprovision(key, resources, nullPriorityAsync);
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getAnyObjectTO(key));
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    @Override
    public ProvisioningResult<AnyObjectTO> provision(String key, Collection<String> resources, boolean changePwd, String password, boolean nullPriorityAsync) {
        AnyObjectTO anyObjectTO = this.binder.getAnyObjectTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(AnyEntitlement.UPDATE.getFor(anyObjectTO.getType()))), (String)anyObjectTO.getRealm());
        this.securityChecks(effectiveRealms, anyObjectTO.getRealm(), anyObjectTO.getKey());
        List statuses = this.provisioningManager.provision(key, resources, nullPriorityAsync);
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getAnyObjectTO(key));
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    @Override
    protected AnyObjectTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (args[i] instanceof AnyObjectTO) {
                    key = ((AnyObjectTO)args[i]).getKey();
                    continue;
                }
                if (!(args[i] instanceof AnyObjectPatch)) continue;
                key = ((AnyObjectPatch)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getAnyObjectTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

