/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.AbstractClassStrategy;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.util.MetaDataException;

public class FlatClassStrategy
extends AbstractClassStrategy {
    public static final String ALIAS = "flat";
    private static final Localizer _loc = Localizer.forPackage(FlatClassStrategy.class);

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    public void map(boolean adapt) {
        Table table;
        ClassMapping sup = this.cls.getMappedPCSuperclassMapping();
        if (sup == null || this.cls.getEmbeddingMetaData() != null) {
            throw new MetaDataException(_loc.get("not-sub", (Object)this.cls));
        }
        ClassMappingInfo info = this.cls.getMappingInfo();
        info.assertNoSchemaComponents((MetaDataContext)this.cls, true);
        if (!DBIdentifier.isNull(info.getTableIdentifier()) && (table = info.createTable((MetaDataContext)this.cls, null, info.getSchemaIdentifier(), info.getTableIdentifier(), false)) != sup.getTable()) {
            throw new MetaDataException(_loc.get("flat-table", (Object)this.cls, (Object)table.getFullName(), (Object)sup.getTable().getFullName()));
        }
        this.cls.setTable(sup.getTable());
        this.cls.setPrimaryKeyColumns(sup.getPrimaryKeyColumns());
        this.cls.setColumnIO(sup.getColumnIO());
    }

    @Override
    public boolean isPrimaryKeyObjectId(boolean hasAll) {
        return this.cls.getMappedPCSuperclassMapping().isPrimaryKeyObjectId(hasAll);
    }
}

