/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.info;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.syncope.common.lib.info.JavaImplInfo;
import org.apache.syncope.common.lib.types.ImplementationType;

@XmlRootElement(name="platformInfo")
@XmlType
public class PlatformInfo
implements Serializable {
    private static final long serialVersionUID = -7941853999417673827L;
    private String version;
    private String buildNumber;
    private final ProvisioningInfo provisioningInfo = new ProvisioningInfo();
    private final WorkflowInfo workflowInfo = new WorkflowInfo();
    private final PersistenceInfo persistenceInfo = new PersistenceInfo();
    private boolean selfRegAllowed;
    private boolean pwdResetAllowed;
    private boolean pwdResetRequiringSecurityQuestions;
    private final Set<String> connIdLocations = new HashSet<String>();
    private String passwordGenerator;
    private final List<String> anyTypes = new ArrayList<String>();
    private final List<String> userClasses = new ArrayList<String>();
    private final List<String> anyTypeClasses = new ArrayList<String>();
    private final List<String> resources = new ArrayList<String>();
    private final Set<String> entitlements = new HashSet<String>();
    private final Set<JavaImplInfo> javaImplInfos = new HashSet<JavaImplInfo>();

    public String getVersion() {
        return this.version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public ProvisioningInfo getProvisioningInfo() {
        return this.provisioningInfo;
    }

    public WorkflowInfo getWorkflowInfo() {
        return this.workflowInfo;
    }

    public PersistenceInfo getPersistenceInfo() {
        return this.persistenceInfo;
    }

    public boolean isSelfRegAllowed() {
        return this.selfRegAllowed;
    }

    public boolean isPwdResetAllowed() {
        return this.pwdResetAllowed;
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return this.pwdResetRequiringSecurityQuestions;
    }

    @XmlElementWrapper(name="connIdLocations")
    @XmlElement(name="connIdLocation")
    @JsonProperty(value="connIdLocations")
    public Set<String> getConnIdLocations() {
        return this.connIdLocations;
    }

    public String getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public void setPasswordGenerator(String passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    @XmlElementWrapper(name="anyTypes")
    @XmlElement(name="anyType")
    @JsonProperty(value="anyTypes")
    public List<String> getAnyTypes() {
        return this.anyTypes;
    }

    @XmlElementWrapper(name="userClasses")
    @XmlElement(name="userClass")
    @JsonProperty(value="userClasses")
    public List<String> getUserClasses() {
        return this.userClasses;
    }

    @XmlElementWrapper(name="anyTypeClasses")
    @XmlElement(name="anyTypeClass")
    @JsonProperty(value="anyTypeClasses")
    public List<String> getAnyTypeClasses() {
        return this.anyTypeClasses;
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="resource")
    @JsonProperty(value="resources")
    public List<String> getResources() {
        return this.resources;
    }

    @XmlElementWrapper(name="entitlements")
    @XmlElement(name="entitlement")
    @JsonProperty(value="entitlements")
    public Set<String> getEntitlements() {
        return this.entitlements;
    }

    @JsonIgnore
    public Optional<JavaImplInfo> getJavaImplInfo(ImplementationType type) {
        return this.javaImplInfos.stream().filter(javaImplInfo -> javaImplInfo.getType() == type).findFirst();
    }

    @XmlElementWrapper(name="javaImplInfos")
    @XmlElement(name="javaImplInfo")
    @JsonProperty(value="javaImplInfos")
    public Set<JavaImplInfo> getJavaImplInfos() {
        return this.javaImplInfos;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setSelfRegAllowed(boolean selfRegAllowed) {
        this.selfRegAllowed = selfRegAllowed;
    }

    public void setPwdResetAllowed(boolean pwdResetAllowed) {
        this.pwdResetAllowed = pwdResetAllowed;
    }

    public void setPwdResetRequiringSecurityQuestions(boolean pwdResetRequiringSecurityQuestions) {
        this.pwdResetRequiringSecurityQuestions = pwdResetRequiringSecurityQuestions;
    }

    @XmlRootElement(name="persistenceInfo")
    @XmlType
    public class PersistenceInfo
    implements Serializable {
        private static final long serialVersionUID = 2902980556801069487L;
        private String entityFactory;
        private String plainSchemaDAO;
        private String plainAttrDAO;
        private String plainAttrValueDAO;
        private String anySearchDAO;
        private String userDAO;
        private String groupDAO;
        private String anyObjectDAO;
        private String confDAO;

        public String getEntityFactory() {
            return this.entityFactory;
        }

        public void setEntityFactory(String entityFactory) {
            this.entityFactory = entityFactory;
        }

        public String getPlainSchemaDAO() {
            return this.plainSchemaDAO;
        }

        public void setPlainSchemaDAO(String plainSchemaDAO) {
            this.plainSchemaDAO = plainSchemaDAO;
        }

        public String getPlainAttrDAO() {
            return this.plainAttrDAO;
        }

        public void setPlainAttrDAO(String plainAttrDAO) {
            this.plainAttrDAO = plainAttrDAO;
        }

        public String getPlainAttrValueDAO() {
            return this.plainAttrValueDAO;
        }

        public void setPlainAttrValueDAO(String plainAttrValueDAO) {
            this.plainAttrValueDAO = plainAttrValueDAO;
        }

        public String getAnySearchDAO() {
            return this.anySearchDAO;
        }

        public void setAnySearchDAO(String anySearchDAO) {
            this.anySearchDAO = anySearchDAO;
        }

        public String getUserDAO() {
            return this.userDAO;
        }

        public void setUserDAO(String userDAO) {
            this.userDAO = userDAO;
        }

        public String getGroupDAO() {
            return this.groupDAO;
        }

        public void setGroupDAO(String groupDAO) {
            this.groupDAO = groupDAO;
        }

        public String getAnyObjectDAO() {
            return this.anyObjectDAO;
        }

        public void setAnyObjectDAO(String anyObjectDAO) {
            this.anyObjectDAO = anyObjectDAO;
        }

        public String getConfDAO() {
            return this.confDAO;
        }

        public void setConfDAO(String confDAO) {
            this.confDAO = confDAO;
        }
    }

    @XmlRootElement(name="workflowInfo")
    @XmlType
    public class WorkflowInfo
    implements Serializable {
        private static final long serialVersionUID = 6736937721099195324L;
        private String anyObjectWorkflowAdapter;
        private String userWorkflowAdapter;
        private String groupWorkflowAdapter;

        public String getAnyObjectWorkflowAdapter() {
            return this.anyObjectWorkflowAdapter;
        }

        public void setAnyObjectWorkflowAdapter(String anyObjectWorkflowAdapter) {
            this.anyObjectWorkflowAdapter = anyObjectWorkflowAdapter;
        }

        public String getUserWorkflowAdapter() {
            return this.userWorkflowAdapter;
        }

        public void setUserWorkflowAdapter(String userWorkflowAdapter) {
            this.userWorkflowAdapter = userWorkflowAdapter;
        }

        public String getGroupWorkflowAdapter() {
            return this.groupWorkflowAdapter;
        }

        public void setGroupWorkflowAdapter(String groupWorkflowAdapter) {
            this.groupWorkflowAdapter = groupWorkflowAdapter;
        }
    }

    @XmlRootElement(name="provisioningInfo")
    @XmlType
    public class ProvisioningInfo
    implements Serializable {
        private static final long serialVersionUID = 533340357732839568L;
        private String propagationTaskExecutor;
        private String virAttrCache;
        private String anyObjectProvisioningManager;
        private String userProvisioningManager;
        private String groupProvisioningManager;

        public String getPropagationTaskExecutor() {
            return this.propagationTaskExecutor;
        }

        public void setPropagationTaskExecutor(String propagationTaskExecutor) {
            this.propagationTaskExecutor = propagationTaskExecutor;
        }

        public String getVirAttrCache() {
            return this.virAttrCache;
        }

        public void setVirAttrCache(String virAttrCache) {
            this.virAttrCache = virAttrCache;
        }

        public String getAnyObjectProvisioningManager() {
            return this.anyObjectProvisioningManager;
        }

        public void setAnyObjectProvisioningManager(String anyObjectProvisioningManager) {
            this.anyObjectProvisioningManager = anyObjectProvisioningManager;
        }

        public String getUserProvisioningManager() {
            return this.userProvisioningManager;
        }

        public void setUserProvisioningManager(String userProvisioningManager) {
            this.userProvisioningManager = userProvisioningManager;
        }

        public String getGroupProvisioningManager() {
            return this.groupProvisioningManager;
        }

        public void setGroupProvisioningManager(String groupProvisioningManager) {
            this.groupProvisioningManager = groupProvisioningManager;
        }
    }
}

