/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.configuration;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.configuration.AbstractConfigurationCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationDelete
extends AbstractConfigurationCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationDelete.class);
    private static final String DELETE_HELP_MESSAGE = "configuration --delete {CONF-NAME} {CONF-NAME} [...]";
    private final Input input;

    public ConfigurationDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.configurationSyncopeOperations.delete(parameter);
                    this.configurationResultManager.deletedMessage("Configuration", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error deleting configuration", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.configurationResultManager.notFoundError("Configuration", parameter);
                    } else if (ex.getMessage().startsWith("DataIntegrityViolation")) {
                        this.configurationResultManager.genericError("You cannot delete configuration " + parameter);
                    } else {
                        this.configurationResultManager.genericError(ex.getMessage());
                    }
                    break;
                }
            }
        } else {
            this.configurationResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

