/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.user;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.cli.SyncopeServices;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.batch.BatchItem;
import org.apache.syncope.common.rest.api.batch.BatchPayloadParser;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.UserService;

public class UserSyncopeOperations {
    private static final int PAGE_SIZE = 100;
    private final UserService userService = SyncopeServices.get(UserService.class);

    public boolean auth(String username, String password) {
        try {
            SyncopeServices.testUsernameAndPassword(username, password);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<UserTO> searchByRole(String realm, String role) {
        return this.search((AnyQuery)new AnyQuery.Builder().realm(realm).fiql(SyncopeClient.getUserSearchConditionBuilder().inRoles(role, new String[0]).query()).build());
    }

    public List<UserTO> searchByResource(String realm, String resource) {
        return this.search((AnyQuery)new AnyQuery.Builder().realm(realm).fiql(SyncopeClient.getUserSearchConditionBuilder().hasResources(resource, new String[0]).query()).build());
    }

    public List<UserTO> searchByAttribute(String realm, String attributeName, String attributeValue) {
        return this.search((AnyQuery)new AnyQuery.Builder().realm(realm).fiql(SyncopeClient.getUserSearchConditionBuilder().is(attributeName).equalTo(attributeValue, new String[0]).query()).build());
    }

    public List<UserTO> list() {
        return this.search(new AnyQuery());
    }

    private List<UserTO> search(AnyQuery query) {
        query.setPage(Integer.valueOf(0));
        query.setSize(Integer.valueOf(0));
        int count = this.userService.search(query).getTotalCount();
        ArrayList<UserTO> result = new ArrayList<UserTO>();
        query.setSize(Integer.valueOf(100));
        for (int page = 1; page <= count / 100 + 1; ++page) {
            query.setPage(Integer.valueOf(page));
            result.addAll(this.userService.search(query).getResult());
        }
        return result;
    }

    public UserTO read(String userKey) {
        return this.userService.read(userKey);
    }

    public void delete(String userKey) {
        this.userService.delete(userKey);
    }

    public List<BatchResponseItem> deleteByAttribute(String realm, String attributeName, String attributeValue) throws IOException {
        return this.batchDelete((AnyQuery)new AnyQuery.Builder().realm(realm).fiql(SyncopeClient.getUserSearchConditionBuilder().is(attributeName).equalTo(attributeValue, new String[0]).query()).build());
    }

    public List<BatchResponseItem> deleteAll(String realm) throws IOException {
        return this.batchDelete((AnyQuery)new AnyQuery.Builder().realm(realm).details(false).build());
    }

    private List<BatchResponseItem> batchDelete(AnyQuery query) throws IOException {
        query.setPage(Integer.valueOf(0));
        query.setSize(Integer.valueOf(0));
        int count = this.userService.search(query).getTotalCount();
        BatchRequest batchRequest = SyncopeServices.batch();
        UserService batchUserService = (UserService)batchRequest.getService(UserService.class);
        query.setSize(Integer.valueOf(100));
        for (int page = 1; page <= count / 100 + 1; ++page) {
            query.setPage(Integer.valueOf(page));
            this.userService.search(query).getResult().forEach(user -> batchUserService.delete(user.getKey()));
        }
        Response response = batchRequest.commit().getResponse();
        return BatchPayloadParser.parse((InputStream)((InputStream)response.getEntity()), (MediaType)response.getMediaType(), (BatchItem)new BatchResponseItem());
    }
}

