/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.group;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.group.AbstractGroupCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.GroupTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDetails
extends AbstractGroupCommand {
    private static final Logger LOG = LoggerFactory.getLogger(GroupDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "group --details";
    private final Input input;

    public GroupDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
                List<GroupTO> groupTOs = this.groupSyncopeOperations.list();
                int withoudResources = 0;
                int withoudAttributes = 0;
                int onRootRealm = 0;
                for (GroupTO groupTO : groupTOs) {
                    if (groupTO.getResources() == null || groupTO.getResources().isEmpty()) {
                        ++withoudResources;
                    }
                    if (!(groupTO.getPlainAttrs() != null && !groupTO.getPlainAttrs().isEmpty() || groupTO.getDerAttrs() != null && !groupTO.getDerAttrs().isEmpty() || groupTO.getVirAttrs() != null && !groupTO.getVirAttrs().isEmpty())) {
                        ++withoudAttributes;
                    }
                    if (!"/".equals(groupTO.getRealm())) continue;
                    ++onRootRealm;
                }
                details.put("Total number", String.valueOf(groupTOs.size()));
                details.put("Without resources", String.valueOf(withoudResources));
                details.put("Without attributes", String.valueOf(withoudAttributes));
                details.put("On root realm", String.valueOf(onRootRealm));
                details.put("On the other realm", String.valueOf(groupTOs.size() - onRootRealm));
                this.groupResultManager.printDetails(details);
            }
            catch (SyncopeClientException ex) {
                LOG.error("Error reading details about realm", (Throwable)ex);
                this.groupResultManager.genericError(ex.getMessage());
            }
        } else {
            this.groupResultManager.unnecessaryParameters(this.input.listParameters(), DETAILS_HELP_MESSAGE);
        }
    }
}

