/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.group;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.group.GroupDelete;
import org.apache.syncope.client.cli.commands.group.GroupDetails;
import org.apache.syncope.client.cli.commands.group.GroupList;
import org.apache.syncope.client.cli.commands.group.GroupRead;
import org.apache.syncope.client.cli.commands.group.GroupReadAttributeBySchemaTypeAndSchemaKey;
import org.apache.syncope.client.cli.commands.group.GroupReadAttributesBySchemaType;
import org.apache.syncope.client.cli.commands.group.GroupResultManager;

@Command(name="group")
public class GroupCommand
extends AbstractCommand {
    private final GroupResultManager groupResultManager = new GroupResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(GroupOptions.HELP.getOptionName());
        }
        switch (GroupOptions.fromName(input.getOption())) {
            case DETAILS: {
                new GroupDetails(input).details();
                break;
            }
            case LIST: {
                new GroupList(input).list();
                break;
            }
            case READ: {
                new GroupRead(input).read();
                break;
            }
            case READ_ATTRIBUTES_BY_SCHEMA_TYPE: {
                new GroupReadAttributesBySchemaType(input).read();
                break;
            }
            case READ_ATTRIBUTES_BY_SCHEMA: {
                new GroupReadAttributeBySchemaTypeAndSchemaKey(input).read();
                break;
            }
            case DELETE: {
                new GroupDelete(input).delete();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.groupResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.groupResultManager.commandHelpMessage(this.getClass());
    }

    public static enum GroupOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        READ("--read"),
        READ_ATTRIBUTES_BY_SCHEMA("--read-attr-by-schema"),
        READ_ATTRIBUTES_BY_SCHEMA_TYPE("--read-attr-by-schema-type"),
        DELETE("--delete");

        private final String optionName;

        private GroupOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static GroupOptions fromName(String name) {
            GroupOptions optionToReturn = HELP;
            for (GroupOptions option : GroupOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (GroupOptions value : GroupOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

