/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.util.CommandUtils;

public class Input {
    private final AbstractCommand command;
    private final String[] parameters;
    private final List<String> commandFields = new ArrayList<String>();
    private String option;

    public static Pair<String, String> toPairParameter(String parameter) throws IllegalArgumentException {
        if (!parameter.contains("=")) {
            throw new IllegalArgumentException("Parameter syntax error!");
        }
        String[] pairParameterArray = parameter.split("=");
        return Pair.of((Object)pairParameterArray[0], (Object)pairParameterArray[1]);
    }

    public Input(String[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        this.command = CommandUtils.fromArgs(args[0]);
        this.commandFields.add(args[0]);
        if (args.length > 1) {
            this.option = args[1];
            this.commandFields.add(args[1]);
        }
        if (args.length > 2) {
            this.parameters = new String[args.length - 2];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = args[i + 2];
                this.commandFields.add(this.parameters[i]);
            }
        } else {
            this.parameters = new String[0];
        }
    }

    public AbstractCommand getCommand() {
        return this.command;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getOption() {
        return this.option;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public List<String> listParameters() {
        return Arrays.asList(this.parameters);
    }

    public String firstParameter() {
        return this.parameters[0];
    }

    public String secondParameter() {
        return this.parameters[1];
    }

    public String thirdParameter() {
        return this.parameters[2];
    }

    public String lastParameter() {
        return this.parameters[this.parameters.length - 1];
    }

    public int parameterNumber() {
        return this.parameters.length;
    }

    public String printCommandFields() {
        StringBuilder commandBuilder = new StringBuilder();
        this.commandFields.forEach(commandField -> commandBuilder.append((String)commandField).append(" "));
        return commandBuilder.toString();
    }
}

