/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib.batch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchItem;
import org.apache.syncope.common.rest.api.batch.BatchPayloadParser;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchResponse {
    private static final Logger LOG = LoggerFactory.getLogger(BatchResponse.class);
    private final String boundary;
    private final String jwt;
    private final URI monitor;
    private Response response;

    public BatchResponse(String boundary, String jwt, Response response) {
        this.boundary = boundary;
        this.jwt = jwt;
        this.monitor = response.getLocation();
        this.response = response;
    }

    public Response getResponse() {
        return this.response;
    }

    public Response poll() {
        if (this.monitor != null) {
            this.response = WebClient.create((URI)this.monitor).header("Authorization", new Object[]{"Bearer " + this.jwt}).type(RESTHeaders.multipartMixedWith((String)this.boundary.substring(2))).get();
        }
        return this.response;
    }

    public List<BatchResponseItem> getItems() throws IOException {
        String body = IOUtils.toString((InputStream)((InputStream)this.response.getEntity()), (String)StandardCharsets.UTF_8.name());
        LOG.debug("Batch response body:\n{}", (Object)body);
        return BatchPayloadParser.parse((InputStream)new ByteArrayInputStream(body.getBytes()), (MediaType)this.response.getMediaType(), (BatchItem)new BatchResponseItem());
    }
}

