/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;

public final class EntityTOUtils {
    public static Map<String, AttrTO> buildAttrMap(Collection<AttrTO> attrs) {
        HashMap result = new HashMap(attrs.size());
        attrs.forEach(attrTO -> result.put(attrTO.getSchema(), attrTO));
        return Collections.unmodifiableMap(result);
    }

    public static Map<Pair<String, String>, RelationshipTO> buildRelationshipMap(Collection<RelationshipTO> relationships) {
        HashMap result = new HashMap(relationships.size());
        relationships.forEach(rel -> result.put(Pair.of((Object)rel.getType(), (Object)rel.getOtherEndKey()), rel));
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, MembershipTO> buildMembershipMap(Collection<MembershipTO> memberships) {
        HashMap result = new HashMap(memberships.size());
        memberships.forEach(memb -> result.put(memb.getGroupKey(), memb));
        return Collections.unmodifiableMap(result);
    }

    private EntityTOUtils() {
    }
}

