/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ide.eclipse.plugin.editors.htmlhelpers;

import java.util.ArrayList;
import java.util.List;

public class AttributeInfo {
    private String attributeName;
    private boolean hasValue;
    private boolean required = false;
    private String description;
    private List<String> values = new ArrayList<String>();
    private AttributeTypeOptions attributeType;

    public AttributeInfo(String attributeName, boolean hasValue) {
        this(attributeName, hasValue, AttributeTypeOptions.NONE);
    }

    public AttributeInfo(String attributeName, boolean hasValue, AttributeTypeOptions attributeType) {
        this(attributeName, hasValue, attributeType, false);
    }

    public AttributeInfo(String attributeName, boolean hasValue, AttributeTypeOptions attributeType, boolean required) {
        this.attributeName = attributeName;
        this.hasValue = hasValue;
        this.attributeType = attributeType;
        this.required = required;
    }

    public AttributeTypeOptions getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeTypeOptions type) {
        this.attributeType = type;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public String[] getValues() {
        return this.values.toArray(new String[this.values.size()]);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static enum AttributeTypeOptions {
        NONE,
        ALIGN,
        VALIGN,
        INPUT_TYPE,
        CSS,
        FILE,
        ID,
        IDREF,
        IDREFS,
        TARGET;

    }
}

