/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf.service;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.logic.scim.SearchCondConverter;
import org.apache.syncope.core.logic.scim.SearchCondVisitor;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.ListResponse;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMSearchRequest;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.apache.syncope.ext.scimv2.api.type.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractService<R extends SCIMResource> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected MessageContext messageContext;
    private UserDAO userDAO;
    private GroupDAO groupDAO;
    private UserLogic userLogic;
    private GroupLogic groupLogic;
    private SCIMDataBinder binder;
    private SCIMConfManager confManager;

    AbstractService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserDAO userDAO() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.userDAO == null) {
                this.userDAO = (UserDAO)ApplicationContextProvider.getApplicationContext().getBean(UserDAO.class);
            }
        }
        return this.userDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroupDAO groupDAO() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.groupDAO == null) {
                this.groupDAO = (GroupDAO)ApplicationContextProvider.getApplicationContext().getBean(GroupDAO.class);
            }
        }
        return this.groupDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserLogic userLogic() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.userLogic == null) {
                this.userLogic = (UserLogic)ApplicationContextProvider.getApplicationContext().getBean(UserLogic.class);
            }
        }
        return this.userLogic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroupLogic groupLogic() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.groupLogic == null) {
                this.groupLogic = (GroupLogic)ApplicationContextProvider.getApplicationContext().getBean(GroupLogic.class);
            }
        }
        return this.groupLogic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SCIMDataBinder binder() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.binder == null) {
                this.binder = (SCIMDataBinder)ApplicationContextProvider.getApplicationContext().getBean(SCIMDataBinder.class);
            }
        }
        return this.binder;
    }

    protected AnyDAO<?> anyDAO(Resource type) {
        switch (type) {
            case User: {
                return this.userDAO();
            }
            case Group: {
                return this.groupDAO();
            }
        }
        throw new UnsupportedOperationException();
    }

    protected AbstractAnyLogic<?, ?> anyLogic(Resource type) {
        switch (type) {
            case User: {
                return this.userLogic();
            }
            case Group: {
                return this.groupLogic();
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SCIMConfManager confManager() {
        AbstractService abstractService = this;
        synchronized (abstractService) {
            if (this.confManager == null) {
                this.confManager = (SCIMConfManager)ApplicationContextProvider.getApplicationContext().getBean(SCIMConfManager.class);
            }
        }
        return this.confManager;
    }

    protected Response createResponse(String key, SCIMResource resource) {
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0])).entity((Object)resource).build();
    }

    protected Response updateResponse(String key, SCIMResource resource) {
        return Response.ok((Object)this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0])).entity((Object)resource).build();
    }

    protected Response.ResponseBuilder checkETag(Resource resource, String key) {
        Date lastChange = this.anyDAO(resource).findLastChange(key);
        if (lastChange == null) {
            throw new NotFoundException("Resource" + key + " not found");
        }
        return this.messageContext.getRequest().evaluatePreconditions(new EntityTag(String.valueOf(lastChange.getTime()), true));
    }

    protected ListResponse<R> doSearch(Resource type, SCIMSearchRequest request) {
        List<Object> sort;
        int itemsPerPage;
        if (type == null) {
            throw new UnsupportedOperationException();
        }
        if (request.getCount() > this.confManager().get().getGeneralConf().getFilterMaxResults()) {
            throw new BadRequestException(ErrorType.tooMany, "Too many results requested");
        }
        SearchCondVisitor visitor = new SearchCondVisitor(type, this.confManager().get());
        int startIndex = request.getStartIndex() <= 1 ? 1 : request.getStartIndex() / 500 + 1;
        int n = itemsPerPage = request.getCount() <= 1 ? 500 : request.getCount();
        if (request.getSortBy() == null) {
            sort = Collections.emptyList();
        } else {
            OrderByClause clause = new OrderByClause();
            clause.setField(visitor.createAttrCond(request.getSortBy()).getSchema());
            clause.setDirection(request.getSortOrder() == null || request.getSortOrder() == SortOrder.ascending ? OrderByClause.Direction.ASC : OrderByClause.Direction.DESC);
            sort = Collections.singletonList(clause);
        }
        Pair result = this.anyLogic(type).search(StringUtils.isBlank((CharSequence)request.getFilter()) ? null : SearchCondConverter.convert((SearchCondVisitor)visitor, (String)request.getFilter()), startIndex, itemsPerPage, sort, "/", false);
        if ((Integer)result.getLeft() > this.confManager().get().getGeneralConf().getFilterMaxResults()) {
            throw new BadRequestException(ErrorType.tooMany, "Too many results found");
        }
        ListResponse response = new ListResponse(((Integer)result.getLeft()).intValue(), startIndex == 1 ? 1 : startIndex - 1, itemsPerPage);
        ((List)result.getRight()).forEach(anyTO -> {
            SCIMUser resource = null;
            if (anyTO instanceof UserTO) {
                resource = this.binder().toSCIMUser((UserTO)anyTO, this.uriInfo.getAbsolutePathBuilder().path(anyTO.getKey()).build(new Object[0]).toASCIIString(), request.getAttributes(), request.getExcludedAttributes());
            } else if (anyTO instanceof GroupTO) {
                resource = this.binder().toSCIMGroup((GroupTO)anyTO, this.uriInfo.getAbsolutePathBuilder().path(anyTO.getKey()).build(new Object[0]).toASCIIString(), request.getAttributes(), request.getExcludedAttributes());
            }
            if (resource != null) {
                response.getResources().add(resource);
            }
        });
        return response;
    }
}

