/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.oidcclient.agent;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.OIDCLoginResponseTO;
import org.apache.syncope.common.rest.api.service.OIDCClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="codeConsumer", urlPatterns={"/oidcclient/code-consumer"})
public class CodeConsumer
extends HttpServlet {
    private static final long serialVersionUID = 968480296813639041L;
    protected static final Logger LOG = LoggerFactory.getLogger(CodeConsumer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            try {
                String authorizationCode = request.getParameter("code");
                String state = request.getParameter("state");
                if (StringUtils.isBlank((CharSequence)authorizationCode) || StringUtils.isBlank((CharSequence)state)) {
                    throw new IllegalArgumentException("Empty code or state");
                }
                if (state.equals(request.getSession().getAttribute("state").toString())) {
                    SyncopeClient anonymous = (SyncopeClient)request.getServletContext().getAttribute("SyncopeAnonymousClient");
                    OIDCLoginResponseTO responseTO = ((OIDCClientService)anonymous.getService(OIDCClientService.class)).login(request.getRequestURL().toString(), authorizationCode, request.getSession().getAttribute("op").toString());
                    if (responseTO.isSelfReg()) {
                        responseTO.getAttrs().add(new AttrTO.Builder().schema("username").values(new String[]{responseTO.getUsername()}).build());
                        request.getSession(true).setAttribute("oidcclient.userattrs", (Object)MAPPER.writeValueAsString((Object)responseTO.getAttrs()));
                        String selfRegRedirectURL = this.getServletContext().getInitParameter("oidcclient.redirect.selfreg");
                        if (selfRegRedirectURL == null) {
                            request.setAttribute("responseTO", (Object)responseTO);
                            request.getRequestDispatcher("loginSuccess.jsp").forward((ServletRequest)request, (ServletResponse)response);
                        } else {
                            response.sendRedirect(selfRegRedirectURL);
                        }
                    } else {
                        request.getSession().setAttribute("oidcclient.jwt", (Object)responseTO.getAccessToken());
                        request.getSession().setAttribute("oidcclient.jwt.expire", (Object)responseTO.getAccessTokenExpiryTime());
                        request.getSession().setAttribute("id.token", (Object)responseTO.getIdToken());
                        String successURL = this.getServletContext().getInitParameter("oidcclient.login.success.url");
                        if (successURL == null) {
                            request.setAttribute("responseTO", (Object)responseTO);
                            request.getRequestDispatcher("loginSuccess.jsp").forward((ServletRequest)request, (ServletResponse)response);
                        } else {
                            response.sendRedirect(successURL + "?logoutSupported=" + responseTO.isLogoutSupported());
                        }
                    }
                    break block11;
                }
                throw new IllegalArgumentException("Invalid state provided");
            }
            catch (Exception e) {
                LOG.error("While processing authentication response from OP", (Throwable)e);
                String errorURL = this.getServletContext().getInitParameter("oidcclient.login.error.url");
                if (errorURL == null) {
                    request.setAttribute("exception", (Object)e);
                    request.getRequestDispatcher("loginError.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    e.printStackTrace(response.getWriter());
                }
                response.sendRedirect(errorURL + "?errorMessage=" + URLEncoder.encode(e.getMessage(), StandardCharsets.UTF_8.name()));
            }
        }
    }
}

