/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.saml2lsp.agent;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.syncope.common.lib.to.SAML2ReceivedResponseTO;
import org.apache.syncope.common.lib.to.SAML2RequestTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAML2SPServlet
extends HttpServlet {
    private static final long serialVersionUID = 7969539245875799817L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSAML2SPServlet.class);

    protected void prepare(HttpServletResponse response, SAML2RequestTO requestTO) throws IOException {
        response.setHeader("Cache-Control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        switch (requestTO.getBindingType()) {
            case REDIRECT: {
                UriBuilder ub = UriBuilder.fromUri((String)requestTO.getIdpServiceAddress());
                ub.queryParam("SAMLRequest", new Object[]{requestTO.getContent()});
                ub.queryParam("RelayState", new Object[]{requestTO.getRelayState()});
                ub.queryParam("SigAlg", new Object[]{requestTO.getSignAlg()});
                ub.queryParam("Signature", new Object[]{requestTO.getSignature()});
                response.setStatus(303);
                response.setHeader("Location", ub.build(new Object[0]).toASCIIString());
                break;
            }
            default: {
                response.setContentType("text/html");
                response.getWriter().write("<html xmlns=\"http://www.w3.org/1999/xhtml\"> <body onLoad=\"document.forms[0].submit();\">  <form action=\"" + requestTO.getIdpServiceAddress() + "\" method=\"POST\">   <input type=\"hidden\" name=\"" + "SAMLRequest" + "\"          value=\"" + requestTO.getContent() + "\"/>   <input type=\"hidden\" name=\"" + "RelayState" + "\"          value=\"" + requestTO.getRelayState() + "\"/>   <input type=\"submit\" style=\"visibility: hidden;\"/>  </form> </body></html>");
            }
        }
    }

    protected SAML2ReceivedResponseTO extract(String spEntityID, String urlContext, String clientAddress, InputStream response) throws IOException {
        String strForm = IOUtils.toString((InputStream)response);
        MultivaluedMap params = JAXRSUtils.getStructuredParams((String)strForm, (String)"&", (boolean)false, (boolean)false);
        String samlResponse = (String)params.getFirst((Object)"SAMLResponse");
        if (StringUtils.isNotBlank((CharSequence)samlResponse)) {
            samlResponse = URLDecoder.decode(samlResponse, StandardCharsets.UTF_8.name());
            LOG.debug("Received SAML Response: {}", (Object)samlResponse);
        }
        String relayState = (String)params.getFirst((Object)"RelayState");
        LOG.debug("Received Relay State: {}", (Object)relayState);
        SAML2ReceivedResponseTO receivedResponseTO = new SAML2ReceivedResponseTO();
        receivedResponseTO.setSpEntityID(spEntityID);
        receivedResponseTO.setUrlContext(urlContext);
        receivedResponseTO.setSamlResponse(samlResponse);
        receivedResponseTO.setRelayState(relayState);
        return receivedResponseTO;
    }
}

