/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.policy.InvalidPasswordRuleConf;
import org.apache.syncope.core.spring.policy.PolicyPattern;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DefaultPasswordGenerator
implements PasswordGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordGenerator.class);
    private static final int VERY_MIN_LENGTH = 0;
    private static final int VERY_MAX_LENGTH = 64;
    private static final int MIN_LENGTH_IF_ZERO = 8;
    protected final Map<String, PasswordRule> perContextPasswordRules = new ConcurrentHashMap<String, PasswordRule>();

    @Override
    @Transactional(readOnly=true)
    public String generate(ExternalResource resource) throws InvalidPasswordRuleConf {
        ArrayList<PasswordPolicy> policies = new ArrayList<PasswordPolicy>();
        if (resource.getPasswordPolicy() != null) {
            policies.add(resource.getPasswordPolicy());
        }
        return this.generate(policies);
    }

    protected List<PasswordRule> getPasswordRules(PasswordPolicy policy) {
        ArrayList<PasswordRule> result = new ArrayList<PasswordRule>();
        for (Implementation impl : policy.getRules()) {
            try {
                ImplementationManager.buildPasswordRule(impl, () -> this.perContextPasswordRules.get(impl.getKey()), instance -> this.perContextPasswordRules.put(impl.getKey(), (PasswordRule)instance)).ifPresent(result::add);
            }
            catch (Exception e) {
                LOG.warn("While building {}", (Object)impl, (Object)e);
            }
        }
        return result;
    }

    @Override
    public String generate(List<PasswordPolicy> policies) throws InvalidPasswordRuleConf {
        ArrayList<DefaultPasswordRuleConf> ruleConfs = new ArrayList<DefaultPasswordRuleConf>();
        policies.stream().forEach(policy -> this.getPasswordRules((PasswordPolicy)policy).stream().filter(rule -> rule.getConf() instanceof DefaultPasswordRuleConf).forEach(rule -> ruleConfs.add((DefaultPasswordRuleConf)rule.getConf())));
        DefaultPasswordRuleConf ruleConf = this.merge(ruleConfs);
        this.check(ruleConf);
        return this.generate(ruleConf);
    }

    private DefaultPasswordRuleConf merge(List<DefaultPasswordRuleConf> defaultRuleConfs) {
        DefaultPasswordRuleConf result = new DefaultPasswordRuleConf();
        result.setMinLength(0);
        result.setMaxLength(64);
        defaultRuleConfs.forEach(ruleConf -> {
            if (ruleConf.getMinLength() > result.getMinLength()) {
                result.setMinLength(ruleConf.getMinLength());
            }
            if (ruleConf.getMaxLength() != 0 && ruleConf.getMaxLength() < result.getMaxLength()) {
                result.setMaxLength(ruleConf.getMaxLength());
            }
            result.getPrefixesNotPermitted().addAll(ruleConf.getPrefixesNotPermitted());
            result.getSuffixesNotPermitted().addAll(ruleConf.getSuffixesNotPermitted());
            if (!result.isNonAlphanumericRequired()) {
                result.setNonAlphanumericRequired(ruleConf.isNonAlphanumericRequired());
            }
            if (!result.isAlphanumericRequired()) {
                result.setAlphanumericRequired(ruleConf.isAlphanumericRequired());
            }
            if (!result.isDigitRequired()) {
                result.setDigitRequired(ruleConf.isDigitRequired());
            }
            if (!result.isLowercaseRequired()) {
                result.setLowercaseRequired(ruleConf.isLowercaseRequired());
            }
            if (!result.isUppercaseRequired()) {
                result.setUppercaseRequired(ruleConf.isUppercaseRequired());
            }
            if (!result.isMustStartWithDigit()) {
                result.setMustStartWithDigit(ruleConf.isMustStartWithDigit());
            }
            if (!result.isMustntStartWithDigit()) {
                result.setMustntStartWithDigit(ruleConf.isMustntStartWithDigit());
            }
            if (!result.isMustEndWithDigit()) {
                result.setMustEndWithDigit(ruleConf.isMustEndWithDigit());
            }
            if (result.isMustntEndWithDigit()) {
                result.setMustntEndWithDigit(ruleConf.isMustntEndWithDigit());
            }
            if (!result.isMustStartWithAlpha()) {
                result.setMustStartWithAlpha(ruleConf.isMustStartWithAlpha());
            }
            if (!result.isMustntStartWithAlpha()) {
                result.setMustntStartWithAlpha(ruleConf.isMustntStartWithAlpha());
            }
            if (!result.isMustStartWithNonAlpha()) {
                result.setMustStartWithNonAlpha(ruleConf.isMustStartWithNonAlpha());
            }
            if (!result.isMustntStartWithNonAlpha()) {
                result.setMustntStartWithNonAlpha(ruleConf.isMustntStartWithNonAlpha());
            }
            if (!result.isMustEndWithNonAlpha()) {
                result.setMustEndWithNonAlpha(ruleConf.isMustEndWithNonAlpha());
            }
            if (!result.isMustntEndWithNonAlpha()) {
                result.setMustntEndWithNonAlpha(ruleConf.isMustntEndWithNonAlpha());
            }
            if (!result.isMustEndWithAlpha()) {
                result.setMustEndWithAlpha(ruleConf.isMustEndWithAlpha());
            }
            if (!result.isMustntEndWithAlpha()) {
                result.setMustntEndWithAlpha(ruleConf.isMustntEndWithAlpha());
            }
            if (!result.isUsernameAllowed()) {
                result.setUsernameAllowed(ruleConf.isUsernameAllowed());
            }
        });
        if (result.getMinLength() == 0) {
            result.setMinLength(result.getMaxLength() < 8 ? result.getMaxLength() : 8);
        }
        return result;
    }

    private void check(DefaultPasswordRuleConf defaultPasswordRuleConf) throws InvalidPasswordRuleConf {
        if (defaultPasswordRuleConf.isMustEndWithAlpha() && defaultPasswordRuleConf.isMustntEndWithAlpha()) {
            throw new InvalidPasswordRuleConf("mustEndWithAlpha and mustntEndWithAlpha are both true");
        }
        if (defaultPasswordRuleConf.isMustEndWithAlpha() && defaultPasswordRuleConf.isMustEndWithDigit()) {
            throw new InvalidPasswordRuleConf("mustEndWithAlpha and mustEndWithDigit are both true");
        }
        if (defaultPasswordRuleConf.isMustEndWithDigit() && defaultPasswordRuleConf.isMustntEndWithDigit()) {
            throw new InvalidPasswordRuleConf("mustEndWithDigit and mustntEndWithDigit are both true");
        }
        if (defaultPasswordRuleConf.isMustEndWithNonAlpha() && defaultPasswordRuleConf.isMustntEndWithNonAlpha()) {
            throw new InvalidPasswordRuleConf("mustEndWithNonAlpha and mustntEndWithNonAlpha are both true");
        }
        if (defaultPasswordRuleConf.isMustStartWithAlpha() && defaultPasswordRuleConf.isMustntStartWithAlpha()) {
            throw new InvalidPasswordRuleConf("mustStartWithAlpha and mustntStartWithAlpha are both true");
        }
        if (defaultPasswordRuleConf.isMustStartWithAlpha() && defaultPasswordRuleConf.isMustStartWithDigit()) {
            throw new InvalidPasswordRuleConf("mustStartWithAlpha and mustStartWithDigit are both true");
        }
        if (defaultPasswordRuleConf.isMustStartWithDigit() && defaultPasswordRuleConf.isMustntStartWithDigit()) {
            throw new InvalidPasswordRuleConf("mustStartWithDigit and mustntStartWithDigit are both true");
        }
        if (defaultPasswordRuleConf.isMustStartWithNonAlpha() && defaultPasswordRuleConf.isMustntStartWithNonAlpha()) {
            throw new InvalidPasswordRuleConf("mustStartWithNonAlpha and mustntStartWithNonAlpha are both true");
        }
        if (defaultPasswordRuleConf.getMinLength() > defaultPasswordRuleConf.getMaxLength()) {
            throw new InvalidPasswordRuleConf("Minimun length (" + defaultPasswordRuleConf.getMinLength() + ")is greater than maximum length (" + defaultPasswordRuleConf.getMaxLength() + ")");
        }
    }

    private String generate(DefaultPasswordRuleConf ruleConf) {
        Object[] generatedPassword = new String[ruleConf.getMinLength()];
        for (int i = 0; i < generatedPassword.length; ++i) {
            generatedPassword[i] = "";
        }
        this.checkStartChar((String[])generatedPassword, ruleConf);
        this.checkEndChar((String[])generatedPassword, ruleConf);
        this.checkRequired((String[])generatedPassword, ruleConf);
        for (int firstEmptyChar = this.firstEmptyChar((String[])generatedPassword); firstEmptyChar < generatedPassword.length - 1; ++firstEmptyChar) {
            generatedPassword[firstEmptyChar] = SecureRandomUtils.generateRandomLetter();
        }
        this.checkPrefixAndSuffix((String[])generatedPassword, ruleConf);
        return StringUtils.join((Object[])generatedPassword);
    }

    private void checkStartChar(String[] generatedPassword, DefaultPasswordRuleConf ruleConf) {
        if (ruleConf.isMustStartWithAlpha()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomLetter();
        }
        if (ruleConf.isMustStartWithNonAlpha() || ruleConf.isMustStartWithDigit()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isMustntStartWithAlpha()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isMustntStartWithDigit()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomLetter();
        }
        if (ruleConf.isMustntStartWithNonAlpha()) {
            generatedPassword[0] = SecureRandomUtils.generateRandomLetter();
        }
        if ("".equals(generatedPassword[0])) {
            generatedPassword[0] = SecureRandomUtils.generateRandomLetter();
        }
    }

    private void checkEndChar(String[] generatedPassword, DefaultPasswordRuleConf ruleConf) {
        if (ruleConf.isMustEndWithAlpha()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomLetter();
        }
        if (ruleConf.isMustEndWithNonAlpha() || ruleConf.isMustEndWithDigit()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isMustntEndWithAlpha()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isMustntEndWithDigit()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomLetter();
        }
        if (ruleConf.isMustntEndWithNonAlpha()) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomLetter();
        }
        if ("".equals(generatedPassword[ruleConf.getMinLength() - 1])) {
            generatedPassword[ruleConf.getMinLength() - 1] = SecureRandomUtils.generateRandomLetter();
        }
    }

    private int firstEmptyChar(String[] generatedPStrings) {
        int index = 0;
        while (!generatedPStrings[index].isEmpty()) {
            ++index;
        }
        return index;
    }

    private void checkRequired(String[] generatedPassword, DefaultPasswordRuleConf ruleConf) {
        if (ruleConf.isDigitRequired() && !PolicyPattern.DIGIT.matcher(StringUtils.join((Object[])generatedPassword)).matches()) {
            generatedPassword[this.firstEmptyChar((String[])generatedPassword)] = SecureRandomUtils.generateRandomNumber();
        }
        if (ruleConf.isUppercaseRequired() && !PolicyPattern.ALPHA_UPPERCASE.matcher(StringUtils.join((Object[])generatedPassword)).matches()) {
            generatedPassword[this.firstEmptyChar((String[])generatedPassword)] = SecureRandomUtils.generateRandomLetter().toUpperCase();
        }
        if (ruleConf.isLowercaseRequired() && !PolicyPattern.ALPHA_LOWERCASE.matcher(StringUtils.join((Object[])generatedPassword)).matches()) {
            generatedPassword[this.firstEmptyChar((String[])generatedPassword)] = SecureRandomUtils.generateRandomLetter().toLowerCase();
        }
        if (ruleConf.isNonAlphanumericRequired() && !PolicyPattern.NON_ALPHANUMERIC.matcher(StringUtils.join((Object[])generatedPassword)).matches()) {
            generatedPassword[this.firstEmptyChar((String[])generatedPassword)] = SecureRandomUtils.generateRandomNonAlphanumericChar(PolicyPattern.NON_ALPHANUMERIC_CHARS_FOR_PASSWORD_VALUES);
        }
    }

    private void checkPrefixAndSuffix(String[] generatedPassword, DefaultPasswordRuleConf ruleConf) {
        ruleConf.getPrefixesNotPermitted().forEach(prefix -> {
            if (StringUtils.join((Object[])generatedPassword).startsWith((String)prefix)) {
                this.checkStartChar(generatedPassword, ruleConf);
            }
        });
        ruleConf.getSuffixesNotPermitted().forEach(suffix -> {
            if (StringUtils.join((Object[])generatedPassword).endsWith((String)suffix)) {
                this.checkEndChar(generatedPassword, ruleConf);
            }
        });
    }
}

