/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.SSOLoginFormPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.to.OIDCProviderTO;
import org.apache.syncope.common.rest.api.service.OIDCProviderService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCSSOLoginFormPanel
extends SSOLoginFormPanel {
    private static final long serialVersionUID = 1154933731474854671L;
    private static final Logger LOG = LoggerFactory.getLogger(OIDCSSOLoginFormPanel.class);

    public OIDCSSOLoginFormPanel(String id) {
        super(id);
        List available = ((OIDCProviderService)SyncopeConsoleSession.get().getAnonymousClient().getService(OIDCProviderService.class)).list();
        final Model model = new Model();
        AjaxDropDownChoicePanel ops = new AjaxDropDownChoicePanel("ops", "OpenID Connect", (IModel)model, false);
        ops.setChoices(available);
        ops.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<OIDCProviderTO>(){
            private static final long serialVersionUID = 1814750973898916102L;

            public Object getDisplayValue(OIDCProviderTO object) {
                return object.getName();
            }

            public String getIdValue(OIDCProviderTO object, int index) {
                return object.getName();
            }

            public OIDCProviderTO getObject(final String id, IModel<? extends List<? extends OIDCProviderTO>> choices) {
                return (OIDCProviderTO)IterableUtils.find((Iterable)((Iterable)choices.getObject()), (Predicate)new Predicate<OIDCProviderTO>(){

                    public boolean evaluate(OIDCProviderTO object) {
                        return object.getName().equals(id);
                    }
                });
            }
        });
        ops.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (model.getObject() != null) {
                    try {
                        RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)new RedirectRequestHandler(UrlUtils.rewriteToContextRelative((String)("oidcclient/login?op=" + URLEncoder.encode(((OIDCProviderTO)model.getObject()).getName(), StandardCharsets.UTF_8.name())), (IRequestCycle)RequestCycle.get())));
                    }
                    catch (Exception e) {
                        LOG.error("Could not redirect to the selected OP {}", (Object)((OIDCProviderTO)model.getObject()).getName(), (Object)e);
                    }
                }
            }
        }});
        ops.setOutputMarkupPlaceholderTag(true);
        ops.setVisible(!available.isEmpty());
        this.add(new Component[]{ops});
    }
}

