/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.panels.SubmitableModalPanel;
import org.apache.syncope.client.console.panels.UserRequestFormDetails;
import org.apache.syncope.client.console.panels.UserRequestFormPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.UserRequestRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.panel.Panel;

public class UserRequestFormModal
extends Panel
implements SubmitableModalPanel,
WizardModalPanel<UserRequestForm> {
    private static final long serialVersionUID = -8847854414429745216L;
    private final UserRequestRestClient restClient = new UserRequestRestClient();
    private final BaseModal<?> modal;
    private final UserRequestForm formTO;
    private final PageReference pageRef;

    public UserRequestFormModal(BaseModal<?> modal, final PageReference pageRef, final UserRequestForm formTO) {
        super("content");
        this.modal = modal;
        this.formTO = formTO;
        this.pageRef = pageRef;
        final MultilevelPanel mlp = new MultilevelPanel("userRequestForm");
        mlp.setFirstLevel((Panel)new UserRequestFormPanel(pageRef, formTO){
            private static final long serialVersionUID = -2195387360323687302L;

            @Override
            protected void viewDetails(AjaxRequestTarget target) {
                mlp.next(this.getString("userRequest.details"), (MultilevelPanel.SecondLevel)new UserRequestFormDetails(pageRef, formTO), target);
            }
        });
        this.add(new Component[]{mlp});
    }

    public void onSubmit(AjaxRequestTarget target) {
        this.restClient.submitForm(this.formTO);
        this.modal.show(false);
        this.modal.close((IPartialPageRequestHandler)target);
        SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
    }

    public void onError(AjaxRequestTarget target) {
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    public UserRequestForm getItem() {
        return this.formTO;
    }
}

