/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.builder;

import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.cocoon.pipeline.AsyncCachePipeline;
import org.apache.cocoon.pipeline.CachingPipeline;
import org.apache.cocoon.pipeline.NonCachingPipeline;
import org.apache.cocoon.pipeline.Pipeline;
import org.apache.cocoon.pipeline.builder.LinkedPipelineComponentBuilder;
import org.apache.cocoon.pipeline.builder.LinkedPipelineConfigurationBuilder;
import org.apache.cocoon.pipeline.builder.LinkedPipelineSetupBuilder;
import org.apache.cocoon.pipeline.builder.LinkedPipelineStarterBuilder;
import org.apache.cocoon.pipeline.component.Finisher;
import org.apache.cocoon.pipeline.component.PipelineComponent;
import org.apache.cocoon.pipeline.component.Starter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PipelineBuilder {
    private PipelineBuilder() {
    }

    public static <PC extends PipelineComponent> LinkedPipelineStarterBuilder<PC> newAsyncCachePipeline() {
        return PipelineBuilder.newPipeline(new AsyncCachePipeline());
    }

    public static <PC extends PipelineComponent> LinkedPipelineStarterBuilder<PC> newCachingPipeline() {
        return PipelineBuilder.newPipeline(new CachingPipeline());
    }

    public static <PC extends PipelineComponent> LinkedPipelineStarterBuilder<PC> newNonCachingPipeline() {
        return PipelineBuilder.newPipeline(new NonCachingPipeline());
    }

    private static <PC extends PipelineComponent> LinkedPipelineStarterBuilder<PC> newPipeline(final Pipeline<PC> pipeline) {
        return new LinkedPipelineStarterBuilder<PC>(){

            @Override
            public LinkedPipelineComponentBuilder<PC> setStarter(PC starter) {
                if (starter == null) {
                    throw new IllegalArgumentException("Parameter 'starter' must be not null");
                }
                if (!(starter instanceof Starter)) {
                    throw new IllegalArgumentException("Parameter 'starter' must be org.apache.cocoon.pipeline.component.Starter instance");
                }
                pipeline.addComponent(starter);
                return new LinkedPipelineComponentBuilder<PC>(){

                    @Override
                    public LinkedPipelineComponentBuilder<PC> addComponent(PC pipelineComponent) {
                        if (pipelineComponent == null) {
                            throw new IllegalArgumentException("Parameter 'pipelineComponent' must be not null");
                        }
                        pipeline.addComponent(pipelineComponent);
                        return this;
                    }

                    @Override
                    public LinkedPipelineConfigurationBuilder<PC> setFinisher(PC finisher) {
                        if (finisher == null) {
                            throw new IllegalArgumentException("Parameter 'finisher' must be not null");
                        }
                        if (!(finisher instanceof Finisher)) {
                            throw new IllegalArgumentException("Parameter 'finisher' must be org.apache.cocoon.pipeline.component.Finisher instance");
                        }
                        pipeline.addComponent(finisher);
                        return new LinkedPipelineConfigurationBuilder<PC>(){

                            @Override
                            public LinkedPipelineSetupBuilder<PC> withEmptyConfiguration() {
                                return this.setConfiguration(Collections.EMPTY_MAP);
                            }

                            @Override
                            public LinkedPipelineSetupBuilder<PC> setConfiguration(Map<String, ? extends Object> parameters) {
                                if (parameters == null) {
                                    throw new IllegalArgumentException("Parameter 'parameters' must be not null");
                                }
                                pipeline.setConfiguration(parameters);
                                return new LinkedPipelineSetupBuilder<PC>(){

                                    @Override
                                    public Pipeline<PC> setup(OutputStream outputStream) {
                                        if (outputStream == null) {
                                            throw new IllegalArgumentException("Parameter 'outputStream' must be not null");
                                        }
                                        pipeline.setup(outputStream);
                                        return pipeline;
                                    }
                                };
                            }
                        };
                    }
                };
            }
        };
    }
}

