/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.event.AnyLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.java.AbstractGroupWorkflowAdapter;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultGroupWorkflowAdapter
extends AbstractGroupWorkflowAdapter {
    @Autowired
    protected ApplicationEventPublisher publisher;

    @Override
    protected WorkflowResult<String> doCreate(GroupTO groupTO) {
        Group group = (Group)this.entityFactory.newEntity(Group.class);
        this.dataBinder.create(group, groupTO);
        group = this.groupDAO.saveAndRefreshDynMemberships(group);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.CREATE, (Any)group, AuthContextUtils.getDomain()));
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.groupDAO.findAllResourceKeys(group.getKey()));
        return new WorkflowResult((Object)group.getKey(), propByRes, "create");
    }

    @Override
    protected WorkflowResult<GroupPatch> doUpdate(Group group, GroupPatch groupPatch) {
        PropagationByResource propByRes = this.dataBinder.update(group, groupPatch);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, this.groupDAO.find(group.getKey()), AuthContextUtils.getDomain()));
        return new WorkflowResult((Object)groupPatch, propByRes, "update");
    }

    @Override
    protected void doDelete(Group group) {
        this.groupDAO.delete((Any)group);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Any)group, AuthContextUtils.getDomain()));
    }
}

