/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AbstractPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidEntityException;
import org.apache.syncope.core.persistence.api.dao.AccountRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.policy.AccountPolicyException;
import org.apache.syncope.core.spring.policy.PasswordPolicyException;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public abstract class AbstractUserWorkflowAdapter
implements UserWorkflowAdapter {
    protected static final Logger LOG = LoggerFactory.getLogger(UserWorkflowAdapter.class);
    @Autowired
    protected UserDataBinder dataBinder;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Resource(name="adminUser")
    protected String adminUser;
    @Resource(name="anonymousUser")
    protected String anonymousUser;
    protected final Map<String, AccountRule> perContextAccountRules = new ConcurrentHashMap<String, AccountRule>();
    protected final Map<String, PasswordRule> perContextPasswordRules = new ConcurrentHashMap<String, PasswordRule>();

    public String getPrefix() {
        return null;
    }

    protected List<AccountPolicy> getAccountPolicies(User user) {
        ArrayList<AccountPolicy> policies = new ArrayList<AccountPolicy>();
        this.userDAO.findAllResources(user).stream().map(ExternalResource::getAccountPolicy).filter(Objects::nonNull).forEach(policies::add);
        this.realmDAO.findAncestors(user.getRealm()).stream().map(Realm::getAccountPolicy).filter(Objects::nonNull).forEach(policies::add);
        return policies;
    }

    protected List<AccountRule> getAccountRules(AccountPolicy policy) {
        ArrayList<AccountRule> result = new ArrayList<AccountRule>();
        for (Implementation impl : policy.getRules()) {
            try {
                ImplementationManager.buildAccountRule((Implementation)impl, () -> this.perContextAccountRules.get(impl.getKey()), instance -> this.perContextAccountRules.put(impl.getKey(), (AccountRule)instance)).ifPresent(result::add);
            }
            catch (Exception e) {
                LOG.warn("While building {}", (Object)impl, (Object)e);
            }
        }
        return result;
    }

    protected List<PasswordPolicy> getPasswordPolicies(User user) {
        ArrayList<PasswordPolicy> policies = new ArrayList<PasswordPolicy>();
        this.userDAO.findAllResources(user).forEach(resource -> Optional.ofNullable(resource.getPasswordPolicy()).filter(p -> !policies.contains(p)).ifPresent(policies::add));
        this.realmDAO.findAncestors(user.getRealm()).forEach(realm -> Optional.ofNullable(realm.getPasswordPolicy()).filter(p -> !policies.contains(p)).ifPresent(policies::add));
        return policies;
    }

    protected List<PasswordRule> getPasswordRules(PasswordPolicy policy) {
        ArrayList<PasswordRule> result = new ArrayList<PasswordRule>();
        for (Implementation impl : policy.getRules()) {
            try {
                ImplementationManager.buildPasswordRule((Implementation)impl, () -> this.perContextPasswordRules.get(impl.getKey()), instance -> this.perContextPasswordRules.put(impl.getKey(), (PasswordRule)instance)).ifPresent(result::add);
            }
            catch (Exception e) {
                LOG.warn("While building {}", (Object)impl, (Object)e);
            }
        }
        return result;
    }

    protected Pair<Boolean, Boolean> enforcePolicies(User user, boolean disablePwdPolicyCheck, String clearPassword) {
        if (!disablePwdPolicyCheck) {
            LOG.debug("Password Policy enforcement");
            try {
                int maxPPSpecHistory = 0;
                for (PasswordPolicy policy : this.getPasswordPolicies(user)) {
                    if (clearPassword == null && !policy.isAllowNullPassword()) {
                        throw new PasswordPolicyException("Password mandatory");
                    }
                    this.getPasswordRules(policy).forEach(rule -> {
                        rule.enforce(user, clearPassword);
                        user.getLinkedAccounts().stream().filter(account -> account.getPassword() != null).forEach(arg_0 -> ((PasswordRule)rule).enforce(arg_0));
                    });
                    boolean matching = false;
                    if (policy.getHistoryLength() > 0) {
                        List pwdHistory = user.getPasswordHistory();
                        matching = pwdHistory.subList(policy.getHistoryLength() >= pwdHistory.size() ? 0 : pwdHistory.size() - policy.getHistoryLength(), pwdHistory.size()).stream().map(old -> Encryptor.getInstance().verify(clearPassword, user.getCipherAlgorithm(), old)).reduce(matching, (accumulator, item) -> accumulator | item);
                    }
                    if (matching) {
                        throw new PasswordPolicyException("Password value was used in the past: not allowed");
                    }
                    if (policy.getHistoryLength() <= maxPPSpecHistory) continue;
                    maxPPSpecHistory = policy.getHistoryLength();
                }
                if (maxPPSpecHistory > 0 && user.getPassword() != null && !user.getPasswordHistory().contains(user.getPassword())) {
                    user.getPasswordHistory().add(user.getPassword());
                }
                if (maxPPSpecHistory < user.getPasswordHistory().size()) {
                    for (int i = 0; i < user.getPasswordHistory().size() - maxPPSpecHistory; ++i) {
                        user.getPasswordHistory().remove(i);
                    }
                }
            }
            catch (InvalidEntityException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Invalid password for {}", (Object)user, (Object)e);
                throw new InvalidEntityException(User.class, EntityViolationType.InvalidPassword, e.getMessage());
            }
        }
        LOG.debug("Account Policy enforcement");
        boolean suspend = false;
        boolean propagateSuspension = false;
        try {
            if (user.getUsername() == null) {
                throw new AccountPolicyException("Null username");
            }
            if (this.adminUser.equals(user.getUsername()) || this.anonymousUser.equals(user.getUsername())) {
                throw new AccountPolicyException("Not allowed: " + user.getUsername());
            }
            List<AccountPolicy> accountPolicies = this.getAccountPolicies(user);
            if (accountPolicies.isEmpty()) {
                if (!Entity.ID_PATTERN.matcher(user.getUsername()).matches()) {
                    throw new AccountPolicyException("Character(s) not allowed: " + user.getUsername());
                }
                user.getLinkedAccounts().stream().filter(account -> account.getUsername() != null).forEach(account -> {
                    if (!Entity.ID_PATTERN.matcher(account.getUsername()).matches()) {
                        throw new AccountPolicyException("Character(s) not allowed: " + account.getUsername());
                    }
                });
            } else {
                for (AccountPolicy policy : accountPolicies) {
                    this.getAccountRules(policy).forEach(rule -> {
                        rule.enforce(user);
                        user.getLinkedAccounts().stream().filter(account -> account.getUsername() != null).forEach(arg_0 -> ((AccountRule)rule).enforce(arg_0));
                    });
                    suspend |= user.getFailedLogins() != null && policy.getMaxAuthenticationAttempts() > 0 && user.getFailedLogins() > policy.getMaxAuthenticationAttempts() && user.isSuspended() == false;
                    propagateSuspension |= policy.isPropagateSuspension();
                }
            }
        }
        catch (InvalidEntityException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Invalid username for {}", (Object)user, (Object)e);
            throw new InvalidEntityException(User.class, EntityViolationType.InvalidUsername, e.getMessage());
        }
        return Pair.of((Object)suspend, (Object)propagateSuspension);
    }

    public UserWorkflowResult<Pair<String, Boolean>> create(UserTO userTO, boolean storePassword) {
        return this.create(userTO, false, null, storePassword);
    }

    protected abstract UserWorkflowResult<Pair<String, Boolean>> doCreate(UserTO var1, boolean var2, Boolean var3, boolean var4);

    public UserWorkflowResult<Pair<String, Boolean>> create(UserTO userTO, boolean disablePwdPolicyCheck, Boolean enabled, boolean storePassword) {
        UserWorkflowResult<Pair<String, Boolean>> result = this.doCreate(userTO, disablePwdPolicyCheck, enabled, storePassword);
        User user = (User)this.userDAO.find((String)((Pair)result.getResult()).getKey());
        this.enforcePolicies(user, disablePwdPolicyCheck, disablePwdPolicyCheck ? null : userTO.getPassword());
        this.userDAO.save((Any)user);
        return result;
    }

    protected abstract UserWorkflowResult<String> doActivate(User var1, String var2);

    public UserWorkflowResult<String> activate(String key, String token) {
        return this.doActivate((User)this.userDAO.authFind(key), token);
    }

    protected abstract UserWorkflowResult<Pair<UserPatch, Boolean>> doUpdate(User var1, UserPatch var2);

    public UserWorkflowResult<Pair<UserPatch, Boolean>> update(UserPatch userPatch) {
        UserWorkflowResult result;
        User user = (User)this.userDAO.find(userPatch.getKey());
        if (userPatch.isEmptyButPassword() && !userPatch.getPassword().isOnSyncope()) {
            PropagationByResource propByRes = new PropagationByResource();
            this.userDAO.findAllResources(user).stream().filter(resource -> userPatch.getPassword().getResources().contains(resource.getKey())).forEach(resource -> propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)resource.getKey())));
            PropagationByResource propByLinkedAccount = new PropagationByResource();
            user.getLinkedAccounts().stream().filter(account -> userPatch.getPassword().getResources().contains(account.getResource().getKey())).forEach(account -> propByLinkedAccount.add(ResourceOperation.UPDATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
            result = new UserWorkflowResult((Object)Pair.of((Object)userPatch, (Object)(user.isSuspended() == false ? 1 : 0)), propByRes, propByLinkedAccount, "update");
        } else {
            result = this.doUpdate((User)this.userDAO.authFind(userPatch.getKey()), userPatch);
        }
        this.enforcePolicies(user, userPatch.getPassword() == null, Optional.ofNullable(userPatch.getPassword()).map(AbstractPatchItem::getValue).orElse(null));
        user = (User)this.userDAO.save((Any)user);
        if (!AuthContextUtils.getUsername().equals(user.getUsername())) {
            HashSet authRealms = new HashSet();
            authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault("USER_READ", Collections.emptySet()));
            authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault("USER_UPDATE", Collections.emptySet()));
            this.userDAO.securityChecks(authRealms, user.getKey(), user.getRealm().getFullPath(), this.userDAO.findAllGroupKeys(user));
        }
        return result;
    }

    protected abstract UserWorkflowResult<String> doSuspend(User var1);

    public UserWorkflowResult<String> suspend(String key) {
        User user = (User)this.userDAO.authFind(key);
        user.setSuspended(Boolean.TRUE);
        return this.doSuspend(user);
    }

    public Pair<UserWorkflowResult<String>, Boolean> internalSuspend(String key) {
        User user = (User)this.userDAO.authFind(key);
        Pair result = null;
        Pair<Boolean, Boolean> enforce = this.enforcePolicies(user, true, null);
        if (((Boolean)enforce.getKey()).booleanValue()) {
            LOG.debug("User {} {} is over the max failed logins", (Object)user.getKey(), (Object)user.getUsername());
            user.setFailedLogins(Integer.valueOf(user.getFailedLogins() - 1));
            user.setSuspended(Boolean.TRUE);
            result = Pair.of(this.doSuspend(user), (Object)enforce.getValue());
        }
        return result;
    }

    protected abstract UserWorkflowResult<String> doReactivate(User var1);

    public UserWorkflowResult<String> reactivate(String key) {
        User user = (User)this.userDAO.authFind(key);
        user.setFailedLogins(Integer.valueOf(0));
        user.setSuspended(Boolean.FALSE);
        return this.doReactivate(user);
    }

    protected abstract void doRequestPasswordReset(User var1);

    public void requestPasswordReset(String key) {
        this.doRequestPasswordReset((User)this.userDAO.authFind(key));
    }

    protected abstract UserWorkflowResult<Pair<UserPatch, Boolean>> doConfirmPasswordReset(User var1, String var2, String var3);

    public UserWorkflowResult<Pair<UserPatch, Boolean>> confirmPasswordReset(String key, String token, String password) {
        User user = (User)this.userDAO.authFind(key);
        this.enforcePolicies(user, false, password);
        user = (User)this.userDAO.save((Any)user);
        return this.doConfirmPasswordReset(user, token, password);
    }

    protected abstract void doDelete(User var1);

    public void delete(String userKey) {
        this.doDelete((User)this.userDAO.authFind(userKey));
    }
}

