/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.util.Collections;
import java.util.HashSet;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public abstract class AbstractAnyObjectWorkflowAdapter
implements AnyObjectWorkflowAdapter {
    @Autowired
    protected AnyObjectDataBinder dataBinder;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected EntityFactory entityFactory;

    public String getPrefix() {
        return null;
    }

    protected abstract WorkflowResult<String> doCreate(AnyObjectTO var1);

    public WorkflowResult<String> create(AnyObjectTO anyObjectTO) {
        return this.doCreate(anyObjectTO);
    }

    protected abstract WorkflowResult<AnyObjectPatch> doUpdate(AnyObject var1, AnyObjectPatch var2);

    public WorkflowResult<AnyObjectPatch> update(AnyObjectPatch anyObjectPatch) {
        WorkflowResult<AnyObjectPatch> result = this.doUpdate((AnyObject)this.anyObjectDAO.authFind(anyObjectPatch.getKey()), anyObjectPatch);
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.find(anyObjectPatch.getKey());
        HashSet authRealms = new HashSet();
        authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault(AnyEntitlement.READ.getFor(anyObject.getType().getKey()), Collections.emptySet()));
        authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault(AnyEntitlement.UPDATE.getFor(anyObject.getType().getKey()), Collections.emptySet()));
        this.anyObjectDAO.securityChecks(authRealms, anyObject.getKey(), anyObject.getRealm().getFullPath(), this.anyObjectDAO.findAllGroupKeys(anyObject));
        return result;
    }

    protected abstract void doDelete(AnyObject var1);

    public void delete(String anyObjectKey) {
        this.doDelete((AnyObject)this.anyObjectDAO.authFind(anyObjectKey));
    }
}

