/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.DeleteOp;

public class DeleteImpl
extends ConnectorAPIOperationRunner
implements DeleteApiOp {
    private static final Log OP_LOG = Log.getLog(DeleteOp.class);

    public DeleteImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public void delete(ObjectClass objectClass, Uid uid, OperationOptions options) {
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        if (ObjectClass.ALL.equals((Object)objectClass)) {
            throw new UnsupportedOperationException("Operation is not allowed on __ALL__ object class");
        }
        Assertions.nullCheck((Object)uid, (String)"uid");
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        Connector connector = this.getConnector();
        ObjectNormalizerFacade normalizer = this.getNormalizer(objectClass);
        Uid normalizedUid = (Uid)normalizer.normalizeAttribute((Attribute)uid);
        SpiOperationLoggingUtil.logOpEntry(OP_LOG, this.getOperationalContext(), DeleteOp.class, "delete", objectClass, normalizedUid, options);
        try {
            ((DeleteOp)connector).delete(objectClass, normalizedUid, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, this.getOperationalContext(), DeleteOp.class, "delete", e);
            throw e;
        }
        SpiOperationLoggingUtil.logOpExit(OP_LOG, this.getOperationalContext(), DeleteOp.class, "delete");
    }
}

