/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.camel.producer;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.camel.producer.AbstractProducer;

public class ProvisionProducer
extends AbstractProducer {
    private final UserDAO userDAO;

    public ProvisionProducer(Endpoint endpoint, AnyTypeKind anyType, UserDAO userDAO) {
        super(endpoint, anyType);
        this.userDAO = userDAO;
    }

    public void process(Exchange exchange) throws Exception {
        String key = (String)exchange.getIn().getBody(String.class);
        List resources = (List)exchange.getProperty("resources", List.class);
        Boolean nullPriorityAsync = (Boolean)exchange.getProperty("nullPriorityAsync", Boolean.class);
        if (this.getAnyTypeKind() == AnyTypeKind.USER) {
            Boolean changePwd = (Boolean)exchange.getProperty("changePwd", Boolean.class);
            String password = (String)exchange.getProperty("password", String.class);
            UserPatch userPatch = new UserPatch();
            userPatch.setKey(key);
            userPatch.getResources().addAll(resources.stream().map(resource -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(resource)).build()).collect(Collectors.toList()));
            if (changePwd.booleanValue()) {
                userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).value((Object)password)).resources((Collection)resources).build());
            }
            PropagationByResource propByRes = new PropagationByResource();
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)resources);
            UserWorkflowResult wfResult = new UserWorkflowResult((Object)Pair.of((Object)userPatch, (Object)null), propByRes, null, "update");
            List taskInfos = this.getPropagationManager().getUserUpdateTasks(wfResult, changePwd.booleanValue(), null);
            PropagationReporter reporter = this.getPropagationTaskExecutor().execute((Collection)taskInfos, nullPriorityAsync.booleanValue());
            exchange.getMessage().setBody((Object)reporter.getStatuses());
        } else {
            PropagationByResource propByRes = new PropagationByResource();
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)resources);
            PropagationByResource propByLinkedAccount = new PropagationByResource();
            this.userDAO.findLinkedAccounts(key).stream().filter(account -> resources.contains(account.getResource().getKey())).forEach(account -> propByLinkedAccount.add(ResourceOperation.UPDATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
            AnyTypeKind anyTypeKind = AnyTypeKind.GROUP;
            if (this.getAnyTypeKind() != null) {
                anyTypeKind = this.getAnyTypeKind();
            }
            List taskInfos = this.getPropagationManager().getUpdateTasks(anyTypeKind, key, false, null, propByRes, propByLinkedAccount, null, null);
            PropagationReporter reporter = this.getPropagationTaskExecutor().execute((Collection)taskInfos, nullPriorityAsync.booleanValue());
            exchange.getMessage().setBody((Object)reporter.getStatuses());
        }
    }
}

