/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyUtils;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.SchemaKeyCheck;

public class SchemaKeyValidator
extends AbstractValidator<SchemaKeyCheck, Schema> {
    public boolean isValid(Schema schema, ConstraintValidatorContext context) {
        if (schema.getKey() == null || !Entity.ID_PATTERN.matcher(schema.getKey()).matches()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidKey, schema.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        if (JPAAnyUtils.matchesFieldName(schema.getKey())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidKey, "Schema key not allowed: " + schema.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        return true;
    }
}

