/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Delegation;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.DelegationCheck;

public class DelegationValidator
extends AbstractValidator<DelegationCheck, Delegation> {
    public boolean isValid(Delegation delegation, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (delegation.getDelegating().equals(delegation.getDelegated())) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.Standard, "delegating must be different from delegated")).addPropertyNode("delegating").addConstraintViolation();
            isValid = false;
        }
        if (isValid && delegation.getEnd() != null && !delegation.getEnd().after(delegation.getStart())) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.Standard, "when end is provided it must to be after start")).addPropertyNode("end").addConstraintViolation();
            isValid = false;
        }
        if (isValid && !delegation.getDelegating().getRoles().containsAll(delegation.getRoles())) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.Standard, "only Roles assigned to delegating User can be granted")).addPropertyNode("roles").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }
}

