/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.APlainAttr;
import org.apache.syncope.core.persistence.api.entity.anyobject.APlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.anyobject.APlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.GPlainAttr;
import org.apache.syncope.core.persistence.api.entity.group.GPlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.group.GPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAnyObject;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class JPAAnyUtils
implements AnyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AnyUtils.class);
    private static final Map<String, Field> USER_FIELDS = new HashMap<String, Field>();
    private static final Map<String, Field> GROUP_FIELDS = new HashMap<String, Field>();
    private static final Map<String, Field> ANY_OBJECT_FIELDS = new HashMap<String, Field>();
    private final AnyTypeKind anyTypeKind;
    private final boolean linkedAccount;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private EntityFactory entityFactory;

    private static void initFieldNames(Class<?> entityClass, Map<String, Field> fields) {
        List classes = ClassUtils.getAllSuperclasses(entityClass);
        classes.add(entityClass);
        classes.forEach(clazz -> {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("pc") || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                fields.put(field.getName(), field);
                if (!"id".equals(field.getName())) continue;
                fields.put("key", field);
            }
        });
    }

    public static boolean matchesFieldName(String candidate) {
        return USER_FIELDS.containsKey(candidate) || GROUP_FIELDS.containsKey(candidate) || ANY_OBJECT_FIELDS.containsKey(candidate);
    }

    protected JPAAnyUtils(AnyTypeKind anyTypeKind) {
        this(anyTypeKind, false);
    }

    protected JPAAnyUtils(AnyTypeKind anyTypeKind, boolean linkedAccount) {
        this.anyTypeKind = anyTypeKind;
        this.linkedAccount = linkedAccount;
    }

    public AnyTypeKind anyTypeKind() {
        return this.anyTypeKind;
    }

    public <T extends Any<?>> Class<T> anyClass() {
        Class result;
        switch (this.anyTypeKind) {
            case GROUP: {
                result = this.entityFactory.groupClass();
                break;
            }
            case ANY_OBJECT: {
                result = this.entityFactory.anyObjectClass();
                break;
            }
            default: {
                result = this.entityFactory.userClass();
            }
        }
        return result;
    }

    public Field getField(String name) {
        Map<String, Field> fields;
        switch (this.anyTypeKind) {
            case GROUP: {
                fields = GROUP_FIELDS;
                break;
            }
            case ANY_OBJECT: {
                fields = ANY_OBJECT_FIELDS;
                break;
            }
            default: {
                fields = USER_FIELDS;
            }
        }
        return fields.get(name);
    }

    public <T extends PlainAttr<?>> Class<T> plainAttrClass() {
        return this.newPlainAttr().getClass();
    }

    public <T extends PlainAttr<?>> T newPlainAttr() {
        PlainAttr result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = this.linkedAccount ? (PlainAttr)this.entityFactory.newEntity(LAPlainAttr.class) : (PlainAttr)this.entityFactory.newEntity(UPlainAttr.class);
                break;
            }
            case GROUP: {
                result = (PlainAttr)this.entityFactory.newEntity(GPlainAttr.class);
                break;
            }
            case ANY_OBJECT: {
                result = (PlainAttr)this.entityFactory.newEntity(APlainAttr.class);
                break;
            }
        }
        return (T)result;
    }

    public <T extends PlainAttrValue> Class<T> plainAttrValueClass() {
        return this.newPlainAttrValue().getClass();
    }

    public <T extends PlainAttrValue> T newPlainAttrValue() {
        PlainAttrValue result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = this.linkedAccount ? (PlainAttrValue)this.entityFactory.newEntity(LAPlainAttrValue.class) : (PlainAttrValue)this.entityFactory.newEntity(UPlainAttrValue.class);
                break;
            }
            case GROUP: {
                result = (PlainAttrValue)this.entityFactory.newEntity(GPlainAttrValue.class);
                break;
            }
            case ANY_OBJECT: {
                result = (PlainAttrValue)this.entityFactory.newEntity(APlainAttrValue.class);
                break;
            }
        }
        return (T)result;
    }

    public <T extends PlainAttrValue> Class<T> plainAttrUniqueValueClass() {
        return this.newPlainAttrUniqueValue().getClass();
    }

    public <T extends PlainAttrValue> T newPlainAttrUniqueValue() {
        PlainAttrValue result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = this.linkedAccount ? (PlainAttrValue)this.entityFactory.newEntity(LAPlainAttrUniqueValue.class) : (PlainAttrValue)this.entityFactory.newEntity(UPlainAttrUniqueValue.class);
                break;
            }
            case GROUP: {
                result = (PlainAttrValue)this.entityFactory.newEntity(GPlainAttrUniqueValue.class);
                break;
            }
            case ANY_OBJECT: {
                result = (PlainAttrValue)this.entityFactory.newEntity(APlainAttrUniqueValue.class);
                break;
            }
        }
        return (T)result;
    }

    public <T extends PlainAttrValue> T clonePlainAttrValue(T src) {
        T dst = src instanceof PlainAttrUniqueValue ? this.newPlainAttrUniqueValue() : this.newPlainAttrValue();
        dst.setBinaryValue(src.getBinaryValue());
        dst.setBooleanValue(src.getBooleanValue());
        dst.setDateValue(src.getDateValue());
        dst.setDoubleValue(src.getDoubleValue());
        dst.setLongValue(src.getLongValue());
        dst.setStringValue(src.getStringValue());
        return dst;
    }

    public <T extends AnyTO> T newAnyTO() {
        UserTO result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new UserTO();
                break;
            }
            case GROUP: {
                result = new GroupTO();
                break;
            }
            case ANY_OBJECT: {
                result = new AnyObjectTO();
                break;
            }
        }
        return (T)result;
    }

    public <P extends AnyPatch> P newAnyPatch(String key) {
        UserPatch result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = new UserPatch();
                break;
            }
            case GROUP: {
                result = new GroupPatch();
                break;
            }
            case ANY_OBJECT: {
                result = new AnyObjectPatch();
                break;
            }
        }
        if (result != null) {
            result.setKey(key);
        }
        return (P)result;
    }

    public <A extends Any<?>> AnyDAO<A> dao() {
        UserDAO result = null;
        switch (this.anyTypeKind) {
            case USER: {
                result = this.userDAO;
                break;
            }
            case GROUP: {
                result = this.groupDAO;
                break;
            }
            case ANY_OBJECT: {
                result = this.anyObjectDAO;
                break;
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public Set<ExternalResource> getAllResources(Any<?> any) {
        HashSet<ExternalResource> resources = new HashSet<ExternalResource>();
        if (any instanceof User) {
            resources.addAll(this.userDAO.findAllResources((User)any));
        } else if (any instanceof Group) {
            resources.addAll(((Group)any).getResources());
        } else if (any instanceof AnyObject) {
            resources.addAll(this.anyObjectDAO.findAllResources((AnyObject)any));
        }
        return resources;
    }

    @Transactional
    public void addAttr(PlainAttrValidationManager validator, String key, PlainSchema schema, String value) {
        Any any = this.dao().find(key);
        HashSet typeOwnClasses = new HashSet();
        typeOwnClasses.addAll(any.getType().getClasses());
        typeOwnClasses.addAll(any.getAuxClasses());
        if (!typeOwnClasses.stream().anyMatch(clazz -> clazz.getPlainSchemas().contains(schema))) {
            LOG.warn("Schema {} not allowed for {}, ignoring", (Object)schema, (Object)any);
            return;
        }
        Object attr = any.getPlainAttr(schema.getKey()).orElse(null);
        if (attr == null) {
            attr = this.newPlainAttr();
            attr.setSchema(schema);
            attr.setOwner(any);
            any.add(attr);
            try {
                attr.add(validator, value, (AnyUtils)this);
                this.dao().save(any);
            }
            catch (InvalidPlainAttrValueException e) {
                LOG.error("Invalid value for attribute {} and {}: {}", new Object[]{schema.getKey(), any, value, e});
            }
        } else {
            LOG.debug("{} has already {} set: {}", new Object[]{any, schema.getKey(), attr.getValuesAsStrings()});
        }
    }

    static {
        JPAAnyUtils.initFieldNames(JPAUser.class, USER_FIELDS);
        JPAAnyUtils.initFieldNames(JPAGroup.class, GROUP_FIELDS);
        JPAAnyUtils.initFieldNames(JPAAnyObject.class, ANY_OBJECT_FIELDS);
    }
}

