/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.task.JPATaskExec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Repository
public class JPATaskExecDAO
extends AbstractDAO<TaskExec>
implements TaskExecDAO {
    @Autowired
    private TaskDAO taskDAO;

    public TaskExec find(String key) {
        return (TaskExec)this.entityManager().find(JPATaskExec.class, (Object)key);
    }

    public List<TaskExec> findRecent(int max) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPATaskExec.class.getSimpleName() + " e WHERE e.end IS NOT NULL ORDER BY e.end DESC", TaskExec.class);
        query.setMaxResults(max);
        return query.getResultList();
    }

    private <T extends Task> TaskExec findLatest(T task, String field) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPATaskExec.class.getSimpleName() + " e WHERE e.task=:task ORDER BY e." + field + " DESC", TaskExec.class);
        query.setParameter("task", task);
        query.setMaxResults(1);
        List result = query.getResultList();
        return result == null || result.isEmpty() ? null : (TaskExec)result.iterator().next();
    }

    public <T extends Task> TaskExec findLatestStarted(T task) {
        return this.findLatest(task, "start");
    }

    public <T extends Task> TaskExec findLatestEnded(T task) {
        return this.findLatest(task, "end");
    }

    protected StringBuilder query(StringBuilder select, Task task, Date before, Date after) {
        StringBuilder query = select.append(JPATaskExec.class.getSimpleName()).append(" e WHERE e.task=:task ");
        if (before != null) {
            query.append("AND e.start <= :before ");
        }
        if (after != null) {
            query.append("AND e.start >= :after ");
        }
        return query;
    }

    public int count(Task task, Date before, Date after) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT COUNT(e) FROM "), task, before, after);
        Query query = this.entityManager().createQuery(queryString.toString());
        query.setParameter("task", (Object)task);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    private String toOrderByStatement(List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        orderByClauses.forEach(clause -> {
            String field = clause.getField().trim();
            if (ReflectionUtils.findField(JPATaskExec.class, (String)field) != null) {
                statement.append("e.").append(field).append(' ').append(clause.getDirection().name());
            }
        });
        if (statement.length() == 0) {
            statement.append(" ORDER BY e.id DESC");
        } else {
            statement.insert(0, " ORDER BY ");
        }
        return statement.toString();
    }

    public List<TaskExec> findAll(Task task, Date before, Date after, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT e FROM "), task, before, after).append(this.toOrderByStatement(orderByClauses));
        Query query = this.entityManager().createQuery(queryString.toString());
        query.setParameter("task", (Object)task);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    @Transactional(rollbackFor={Throwable.class})
    public TaskExec save(TaskExec execution) {
        return (TaskExec)this.entityManager().merge((Object)execution);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void saveAndAdd(String taskKey, TaskExec execution) {
        Task task = this.taskDAO.find(taskKey);
        task.add(execution);
        this.taskDAO.save(task);
    }

    public void delete(String key) {
        TaskExec execution = this.find(key);
        if (execution == null) {
            return;
        }
        this.delete(execution);
    }

    public void delete(TaskExec execution) {
        if (execution.getTask() != null) {
            execution.getTask().getExecs().remove(execution);
        }
        this.entityManager().remove((Object)execution);
    }
}

