/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAExternalResource;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPAImplementationDAO
extends AbstractDAO<Implementation>
implements ImplementationDAO {
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private EntityCacheDAO entityCacheDAO;

    @Transactional(readOnly=true)
    public Implementation find(String key) {
        return (Implementation)this.entityManager().find(JPAImplementation.class, (Object)key);
    }

    public List<Implementation> find(ImplementationType type) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAImplementation.class.getSimpleName() + " e WHERE e.type=:type", Implementation.class);
        query.setParameter("type", (Object)type);
        return query.getResultList();
    }

    public List<Implementation> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAImplementation.class.getSimpleName() + " e", Implementation.class);
        return query.getResultList();
    }

    public Implementation save(Implementation implementation) {
        Implementation merged = (Implementation)this.entityManager().merge((Object)implementation);
        ImplementationManager.purge((String)merged.getKey());
        this.resourceDAO.findByProvisionSorter(merged).forEach(resource -> this.entityCacheDAO.evict(JPAExternalResource.class, resource.getKey()));
        return merged;
    }

    public void delete(String key) {
        Implementation implementation = this.find(key);
        if (implementation == null) {
            return;
        }
        this.entityManager().remove((Object)implementation);
        ImplementationManager.purge((String)key);
    }
}

