/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.datacache.CacheStatisticsSPI;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.QueryResultCacheImpl;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.springframework.stereotype.Repository;

@Repository
public class JPAEntityCacheDAO
extends AbstractDAO<Entity>
implements EntityCacheDAO {
    protected CacheStatisticsSPI cacheStatisticsSPI() {
        return (CacheStatisticsSPI)OpenJPAPersistence.cast((EntityManagerFactory)this.entityManagerFactory()).getStoreCache().getStatistics();
    }

    protected QueryStatistics<QueryKey> queryStatistics() {
        return ((QueryResultCacheImpl)OpenJPAPersistence.cast((EntityManagerFactory)this.entityManagerFactory()).getQueryResultCache()).getDelegate().getStatistics();
    }

    public Map<String, Object> getStatistics() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        CacheStatisticsSPI cacheStats = this.cacheStatisticsSPI();
        LinkedHashMap<String, Object> storeCache = new LinkedHashMap<String, Object>();
        result.put("storeCache", storeCache);
        storeCache.put("enabled", cacheStats.isEnabled());
        storeCache.put("activation", DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(cacheStats.start()));
        storeCache.put("last_update", DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(cacheStats.since()));
        storeCache.put("hits", cacheStats.getHitCount());
        storeCache.put("reads", cacheStats.getReadCount());
        storeCache.put("writes", cacheStats.getWriteCount());
        storeCache.put("total_hits", cacheStats.getTotalHitCount());
        storeCache.put("total_reads", cacheStats.getTotalReadCount());
        storeCache.put("total_writes", cacheStats.getTotalWriteCount());
        ArrayList storeCacheDetails = new ArrayList();
        storeCache.put("details", storeCacheDetails);
        cacheStats.classNames().forEach(arg_0 -> JPAEntityCacheDAO.lambda$getStatistics$0((CacheStatistics)cacheStats, storeCache, storeCacheDetails, arg_0));
        QueryStatistics<QueryKey> queryStats = this.queryStatistics();
        LinkedHashMap<String, Object> queryCache = new LinkedHashMap<String, Object>();
        result.put("queryCache", queryCache);
        queryCache.put("activation", DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(queryStats.start()));
        queryCache.put("last_update", DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(queryStats.since()));
        queryCache.put("hits", queryStats.getHitCount());
        queryCache.put("executions", queryStats.getExecutionCount());
        queryCache.put("evictions", queryStats.getEvictionCount());
        queryCache.put("total_hits", queryStats.getTotalHitCount());
        queryCache.put("total_executions", queryStats.getTotalExecutionCount());
        queryCache.put("total_evictions", queryStats.getTotalEvictionCount());
        ArrayList queryCacheDetails = new ArrayList();
        queryCache.put("details", queryCacheDetails);
        queryStats.keys().forEach(queryKey -> {
            LinkedHashMap<String, String> queryKeyMap = new LinkedHashMap<String, String>();
            queryKeyMap.put("query_key", queryKey.toString());
            queryCache.put("hits", queryStats.getHitCount(queryKey));
            queryCache.put("executions", queryStats.getExecutionCount(queryKey));
            queryCache.put("total_hits", queryStats.getTotalHitCount(queryKey));
            queryCache.put("total_executions", queryStats.getTotalExecutionCount(queryKey));
            queryCacheDetails.add(queryKeyMap);
        });
        return result;
    }

    public void enableStatistics() {
        this.cacheStatisticsSPI().enable();
    }

    public void disableStatistics() {
        this.cacheStatisticsSPI().disable();
    }

    public void resetStatistics() {
        this.cacheStatisticsSPI().reset();
        this.queryStatistics().reset();
    }

    public void evict(Class<? extends Entity> entityClass, String key) {
        OpenJPAEntityManagerFactory emf = OpenJPAPersistence.cast((EntityManagerFactory)this.entityManagerFactory());
        emf.getStoreCache().evict(entityClass, (Object)key);
    }

    public void clearCache() {
        OpenJPAEntityManagerFactory emf = OpenJPAPersistence.cast((EntityManagerFactory)this.entityManagerFactory());
        emf.getStoreCache().evictAll();
        emf.getQueryResultCache().evictAll();
    }

    private static /* synthetic */ void lambda$getStatistics$0(CacheStatistics cacheStats, Map storeCache, List storeCacheDetails, String className) {
        LinkedHashMap<String, Object> classMap = new LinkedHashMap<String, Object>();
        classMap.put("region", className);
        classMap.put("hits", cacheStats.getHitCount(className));
        classMap.put("reads", cacheStats.getReadCount(className));
        classMap.put("writes", cacheStats.getWriteCount(className));
        storeCache.put("total_hits", cacheStats.getTotalHitCount(className));
        storeCache.put("total_reads", cacheStats.getTotalReadCount(className));
        storeCache.put("total_writes", cacheStats.getTotalWriteCount(className));
        storeCacheDetails.add(classMap);
    }
}

