/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPADynRealm;
import org.apache.syncope.core.provisioning.api.event.AnyLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPADynRealmDAO
extends AbstractDAO<DynRealm>
implements DynRealmDAO {
    public static final String DYNMEMB_TABLE = "DynRealmMembers";
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private AnyMatchDAO anyMatchDAO;
    @Autowired
    private SearchCondVisitor searchCondVisitor;

    public DynRealm find(String key) {
        return (DynRealm)this.entityManager().find(JPADynRealm.class, (Object)key);
    }

    public List<DynRealm> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADynRealm.class.getSimpleName() + " e ", DynRealm.class);
        return query.getResultList();
    }

    public DynRealm save(DynRealm dynRealm) {
        return (DynRealm)this.entityManager().merge((Object)dynRealm);
    }

    private List<String> clearDynMembers(DynRealm dynRealm) {
        Query find = this.entityManager().createNativeQuery("SELECT any_id FROM DynRealmMembers WHERE dynRealm_id=?");
        find.setParameter(1, (Object)dynRealm.getKey());
        ArrayList<String> cleared = new ArrayList<String>();
        find.getResultList().stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).forEach(key -> cleared.add((String)key));
        Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRealmMembers WHERE dynRealm_id=?");
        delete.setParameter(1, (Object)dynRealm.getKey());
        delete.executeUpdate();
        return cleared;
    }

    private void notifyDynMembershipRemoval(List<String> anyKeys) {
        anyKeys.forEach(key -> {
            Any any = this.userDAO.find(key);
            if (any == null) {
                any = this.groupDAO.find(key);
            }
            if (any == null) {
                any = this.anyObjectDAO.find(key);
            }
            if (any != null) {
                this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, any, AuthContextUtils.getDomain()));
            }
        });
    }

    public DynRealm saveAndRefreshDynMemberships(DynRealm dynRealm) {
        DynRealm merged = this.save(dynRealm);
        List<String> cleared = this.clearDynMembers(merged);
        merged.getDynMemberships().stream().map(memb -> this.searchDAO.search(SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)memb.getFIQLCond(), (String[])new String[0]), memb.getAnyType().getKind())).forEach(matching -> matching.forEach(any -> {
            Query insert = this.entityManager().createNativeQuery("INSERT INTO DynRealmMembers VALUES(?, ?)");
            insert.setParameter(1, (Object)any.getKey());
            insert.setParameter(2, (Object)merged.getKey());
            insert.executeUpdate();
            this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, any, AuthContextUtils.getDomain()));
            cleared.remove(any.getKey());
        }));
        this.notifyDynMembershipRemoval(cleared);
        return merged;
    }

    public void delete(String key) {
        DynRealm dynRealm = this.find(key);
        if (dynRealm == null) {
            return;
        }
        this.notifyDynMembershipRemoval(this.clearDynMembers(dynRealm));
        this.entityManager().remove((Object)dynRealm);
    }

    @Transactional
    public void refreshDynMemberships(Any<?> any) {
        this.findAll().forEach(dynRealm -> dynRealm.getDynMembership(any.getType()).ifPresent(memb -> {
            boolean existing;
            boolean matches = this.anyMatchDAO.matches(any, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)memb.getFIQLCond(), (String[])new String[0]));
            Query find = this.entityManager().createNativeQuery("SELECT dynRealm_id FROM DynRealmMembers WHERE any_id=?");
            find.setParameter(1, (Object)any.getKey());
            boolean bl = existing = !find.getResultList().isEmpty();
            if (matches && !existing) {
                Query insert = this.entityManager().createNativeQuery("INSERT INTO DynRealmMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)any.getKey());
                insert.setParameter(2, (Object)dynRealm.getKey());
                insert.executeUpdate();
            } else if (!matches && existing) {
                Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRealmMembers WHERE dynRealm_id=? AND any_id=?");
                delete.setParameter(1, (Object)dynRealm.getKey());
                delete.setParameter(2, (Object)any.getKey());
                delete.executeUpdate();
            }
        }));
    }

    public void removeDynMemberships(String anyKey) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRealmMembers WHERE any_id=?");
        delete.setParameter(1, (Object)anyKey);
        delete.executeUpdate();
    }
}

