/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttr;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.conf.Conf;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class JPAConfDAO
extends AbstractDAO<Conf>
implements ConfDAO {
    private static final String KEY = "cd64d66f-6fff-4008-b966-a06b1cc1436d";
    @Autowired
    private EntityFactory entityFactory;

    public Conf get() {
        Conf instance = (Conf)this.entityManager().find(this.entityFactory.confClass(), (Object)KEY);
        if (instance == null) {
            instance = (Conf)this.entityFactory.newEntity(Conf.class);
            instance.setKey(KEY);
            instance = (Conf)this.entityManager().merge((Object)instance);
        }
        return instance;
    }

    @Transactional(readOnly=true)
    public Optional<? extends CPlainAttr> find(String key) {
        return this.get().getPlainAttr(key);
    }

    @Transactional(readOnly=true)
    public List<String> getValuesAsStrings(String key) {
        return this.find(key).map(PlainAttr::getValuesAsStrings).orElse(Collections.emptyList());
    }

    @Transactional(readOnly=true)
    public <T> T find(String key, T defaultValue) {
        return (T)this.find(key).map(attr -> attr.getUniqueValue() == null ? (attr.getValues().isEmpty() ? null : ((CPlainAttrValue)attr.getValues().get(0)).getValue()) : attr.getUniqueValue().getValue()).orElse(defaultValue);
    }

    public Conf save(CPlainAttr attr) {
        Conf instance = this.get();
        Optional old = instance.getPlainAttr(attr.getSchema().getKey());
        if (!(!old.isPresent() || attr.getSchema().isUniqueConstraint() && attr.getUniqueValue().getStringValue().equals(((CPlainAttr)old.get()).getUniqueValue().getStringValue()))) {
            ((CPlainAttr)old.get()).setOwner(null);
            instance.remove((PlainAttr)old.get());
        }
        instance.add((PlainAttr)attr);
        attr.setOwner((Any)instance);
        return (Conf)this.entityManager().merge((Object)instance);
    }

    public Conf delete(String key) {
        Conf instance = this.get();
        Optional attr = instance.getPlainAttr(key);
        if (attr.isPresent()) {
            ((CPlainAttr)attr.get()).setOwner(null);
            instance.remove((PlainAttr)attr.get());
            instance = (Conf)this.entityManager().merge((Object)instance);
        }
        return instance;
    }
}

