/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.attrvalue.validation;

import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.attrvalue.validation.AbstractValidator;

public class BasicValidator
extends AbstractValidator {
    private static final long serialVersionUID = -2606728447694223607L;

    @Override
    protected void doValidate(PlainSchema schema, PlainAttrValue attrValue) {
        if (AttrSchemaType.Enum == schema.getType()) {
            String[] enumeration = schema.getEnumerationValues().split(";");
            String value = attrValue.getStringValue();
            boolean found = false;
            for (int i = 0; i < enumeration.length && !found; ++i) {
                if (!enumeration[i].trim().equals(value)) continue;
                found = true;
            }
            if (!found) {
                throw new InvalidPlainAttrValueException('\'' + value + "' is not one of: " + schema.getEnumerationValues());
            }
        }
    }
}

