/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.syncope.common.rest.api.beans.RemediationQuery;
import org.apache.syncope.common.rest.api.service.RemediationService;
import org.apache.syncope.core.logic.RemediationLogic;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemediationServiceImpl
extends AbstractServiceImpl
implements RemediationService {
    @Autowired
    private RemediationLogic logic;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;

    public PagedResult<RemediationTO> list(RemediationQuery query) {
        Pair result = this.logic.list(query.getBefore(), query.getAfter(), query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public RemediationTO read(String key) {
        return this.logic.read(key);
    }

    public Response delete(String key) {
        this.logic.delete(key);
        return Response.noContent().build();
    }

    public Response remedy(String remediationKey, AnyTO anyTO) {
        ProvisioningResult created = this.logic.remedy(remediationKey, anyTO, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    private void check(String key, String anyKey) {
        UserDAO anyDAO;
        RemediationTO remediation = this.logic.read(key);
        switch (remediation.getAnyType()) {
            case "USER": {
                anyDAO = this.userDAO;
                break;
            }
            case "GROUP": {
                anyDAO = this.groupDAO;
                break;
            }
            default: {
                anyDAO = this.anyObjectDAO;
            }
        }
        Date etagDate = anyDAO.findLastChange(anyKey);
        if (etagDate == null) {
            throw new NotFoundException(remediation.getAnyType() + " for " + key);
        }
        this.checkETag(String.valueOf(etagDate.getTime()));
    }

    public Response remedy(String remediationKey, AnyPatch anyPatch) {
        this.check(remediationKey, anyPatch.getKey());
        ProvisioningResult updated = this.logic.remedy(remediationKey, anyPatch, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response remedy(String remediationKey, String anyKey) {
        this.check(remediationKey, anyKey);
        ProvisioningResult deleted = this.logic.remedy(remediationKey, anyKey, this.isNullPriorityAsync());
        return this.modificationResponse(deleted);
    }
}

