/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.log.AuditEntry;
import org.apache.syncope.common.lib.log.EventCategory;
import org.apache.syncope.common.lib.log.LogAppender;
import org.apache.syncope.common.lib.log.LogStatement;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.LoggerType;
import org.apache.syncope.common.rest.api.LoggerWrapper;
import org.apache.syncope.common.rest.api.beans.AuditQuery;
import org.apache.syncope.common.rest.api.service.LoggerService;
import org.apache.syncope.core.logic.LoggerLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoggerServiceImpl
extends AbstractServiceImpl
implements LoggerService {
    @Autowired
    private LoggerLogic logic;

    public List<LogAppender> memoryAppenders() {
        return this.logic.memoryAppenders();
    }

    public List<LogStatement> getLastLogStatements(String memoryAppender) {
        return this.logic.getLastLogStatements(memoryAppender);
    }

    public void delete(LoggerType type, String name) {
        switch (type) {
            case LOG: {
                this.logic.deleteLog(name);
                break;
            }
            case AUDIT: {
                try {
                    this.logic.disableAudit(AuditLoggerName.fromLoggerName((String)name));
                    break;
                }
                catch (IllegalArgumentException | ParseException e) {
                    throw new BadRequestException((Throwable)e);
                }
            }
            default: {
                throw new BadRequestException();
            }
        }
    }

    public List<LoggerTO> list(LoggerType type) {
        switch (type) {
            case LOG: {
                return this.logic.listLogs();
            }
            case AUDIT: {
                List auditLogger = this.logic.listAudits();
                return LoggerWrapper.unwrap((Collection)auditLogger);
            }
        }
        throw new BadRequestException();
    }

    public LoggerTO read(LoggerType type, String name) {
        switch (type) {
            case LOG: {
                return this.logic.readLog(name);
            }
            case AUDIT: {
                return this.logic.readAudit(name);
            }
        }
        throw new BadRequestException();
    }

    public void update(LoggerType type, LoggerTO logger) {
        switch (type) {
            case LOG: {
                this.logic.setLogLevel(logger.getKey(), logger.getLevel().getLevel());
                break;
            }
            case AUDIT: {
                try {
                    this.logic.enableAudit(AuditLoggerName.fromLoggerName((String)logger.getKey()));
                    break;
                }
                catch (Exception e) {
                    throw new BadRequestException((Throwable)e);
                }
            }
            default: {
                throw new BadRequestException();
            }
        }
    }

    public List<EventCategory> events() {
        return this.logic.listAuditEvents();
    }

    public PagedResult<AuditEntry> search(AuditQuery auditQuery) {
        Pair result = this.logic.search(auditQuery.getEntityKey(), auditQuery.getPage().intValue(), auditQuery.getSize().intValue(), auditQuery.getType(), auditQuery.getCategory(), auditQuery.getSubcategory(), auditQuery.getEvents(), auditQuery.getResult(), auditQuery.getBefore(), auditQuery.getAfter(), this.getOrderByClauses(auditQuery.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), auditQuery.getPage(), auditQuery.getSize(), (Integer)result.getLeft());
    }
}

