/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.okta.OktaConnector;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.Uid;
import org.openapitools.client.api.ApplicationApi;
import org.openapitools.client.api.GroupApi;
import org.openapitools.client.api.UserApi;
import org.openapitools.client.model.Application;
import org.openapitools.client.model.ApplicationLifecycleStatus;
import org.openapitools.client.model.Group;
import org.openapitools.client.model.User;
import org.openapitools.client.model.UserProfile;
import org.openapitools.client.model.UserStatus;

public final class OktaAttribute {
    private static final Log LOG = Log.getLog(OktaAttribute.class);
    public static final String ID = "id";
    public static final String STATUS = "status";
    public static final String SCHEMA_PROPERTIES = "properties";
    public static final String EMAIL = "email";
    public static final String LOGIN = "login";
    public static final String SECOND_EMAIL = "secondEmail";
    public static final String LASTNAME = "lastName";
    public static final String FIRSTNAME = "firstName";
    public static final String MOBILEPHONE = "mobilePhone";
    public static final String OKTA_GROUPS = "oktaGroups";
    public static final String NAME = "name";
    public static final String LABEL = "label";
    public static final String DESCRIPTION = "description";
    public static final String LASTUPDATED = "lastUpdated";
    public static final String OKTA_SECURITY_QUESTION = "oktaSecurityQuestion";
    public static final String OKTA_SECURITY_ANSWER = "oktaSecurityAnswer";
    public static final List<String> BASIC_PROFILE_ATTRIBUTES = new ArrayList<String>(){
        private static final long serialVersionUID = 5636572627689425575L;
        {
            this.add(OktaAttribute.EMAIL);
            this.add(OktaAttribute.LOGIN);
            this.add(OktaAttribute.SECOND_EMAIL);
            this.add(OktaAttribute.LASTNAME);
            this.add(OktaAttribute.FIRSTNAME);
            this.add(OktaAttribute.MOBILEPHONE);
        }
    };

    public static Class<?> getType(String type) {
        if (StringUtil.isBlank((String)type)) {
            return String.class;
        }
        Class typeClass = String.class;
        switch (type) {
            case "String": {
                typeClass = String.class;
                break;
            }
            case "Boolean": {
                typeClass = Boolean.class;
                break;
            }
            case "Integer": {
                typeClass = Integer.class;
                break;
            }
        }
        return typeClass;
    }

    public static Set<Attribute> buildUserAttributes(UserApi userApi, User user, Schema schema, Set<String> attributesToGet) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        ObjectClassInfo objectClassInfo = schema.findObjectClassInfo(ObjectClass.ACCOUNT_NAME);
        UserProfile userProfile = user.getProfile();
        attributesToGet.stream().filter(name -> !Name.NAME.equals(name) && !Uid.NAME.equals(name)).forEach(name -> {
            if (ID.equals(name)) {
                attributes.add(AttributeBuilder.build((String)name, (Object[])new Object[]{user.getId()}));
            } else if (STATUS.equals(name)) {
                attributes.add(OktaAttribute.buildAttribute(user.getStatus().toString(), name, String.class).build());
            } else if (OperationalAttributes.ENABLE_NAME.equals(name)) {
                attributes.add(OktaAttribute.buildAttribute(user.getStatus() == UserStatus.ACTIVE, name, Boolean.class).build());
            } else if (OKTA_GROUPS.equals(name)) {
                try {
                    List assignedGroups = userApi.listUserGroups(user.getId()).stream().filter(item -> !OktaAttribute.isDefaultEveryoneGroup(item)).map(Group::getId).collect(Collectors.toList());
                    attributes.add(OktaAttribute.buildAttribute(assignedGroups, name, Set.class).build());
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex, "Could not list groups for User {0}", new Object[]{user.getId()});
                }
            } else if (LASTUPDATED.equals(name)) {
                attributes.add(OktaAttribute.buildAttribute(user.getLastUpdated() != null ? user.getLastUpdated().toInstant().toEpochMilli() : 0L, name, Long.class).build());
            } else {
                objectClassInfo.getAttributeInfo().stream().filter(attr -> attr.getName().equals(name)).findFirst().ifPresent(attributeInfo -> {
                    String value;
                    switch (name) {
                        case "city": {
                            value = userProfile.getCity();
                            break;
                        }
                        case "costCenter": {
                            value = userProfile.getCostCenter();
                            break;
                        }
                        case "countryCode": {
                            value = userProfile.getCountryCode();
                            break;
                        }
                        case "department": {
                            value = userProfile.getDepartment();
                            break;
                        }
                        case "displayName": {
                            value = userProfile.getDisplayName();
                            break;
                        }
                        case "division": {
                            value = userProfile.getDivision();
                            break;
                        }
                        case "email": {
                            value = userProfile.getEmail();
                            break;
                        }
                        case "employeeNumber": {
                            value = userProfile.getEmployeeNumber();
                            break;
                        }
                        case "firstName": {
                            value = userProfile.getFirstName();
                            break;
                        }
                        case "honorificPrefix": {
                            value = userProfile.getHonorificPrefix();
                            break;
                        }
                        case "honorificSuffix": {
                            value = userProfile.getHonorificSuffix();
                            break;
                        }
                        case "lastName": {
                            value = userProfile.getLastName();
                            break;
                        }
                        case "locale": {
                            value = userProfile.getLocale();
                            break;
                        }
                        case "login": {
                            value = userProfile.getLogin();
                            break;
                        }
                        case "manager": {
                            value = userProfile.getManager();
                            break;
                        }
                        case "managerId": {
                            value = userProfile.getManagerId();
                            break;
                        }
                        case "middleName": {
                            value = userProfile.getMiddleName();
                            break;
                        }
                        case "mobilePhone": {
                            value = userProfile.getMobilePhone();
                            break;
                        }
                        case "nickName": {
                            value = userProfile.getNickName();
                            break;
                        }
                        case "organization": {
                            value = userProfile.getOrganization();
                            break;
                        }
                        case "postalAddress": {
                            value = userProfile.getPostalAddress();
                            break;
                        }
                        case "preferredLanguage": {
                            value = userProfile.getPreferredLanguage();
                            break;
                        }
                        case "primaryPhone": {
                            value = userProfile.getPrimaryPhone();
                            break;
                        }
                        case "profileUrl": {
                            value = userProfile.getProfileUrl();
                            break;
                        }
                        case "secondEmail": {
                            value = userProfile.getSecondEmail();
                            break;
                        }
                        case "state": {
                            value = userProfile.getState();
                            break;
                        }
                        case "streetAddress": {
                            value = userProfile.getStreetAddress();
                            break;
                        }
                        case "timezone": {
                            value = userProfile.getTimezone();
                            break;
                        }
                        case "title": {
                            value = userProfile.getTitle();
                            break;
                        }
                        case "userType": {
                            value = userProfile.getUserType();
                            break;
                        }
                        case "zipCode": {
                            value = userProfile.getZipCode();
                            break;
                        }
                        default: {
                            value = userProfile.getAdditionalProperties().get(name);
                        }
                    }
                    attributes.add(OktaAttribute.buildAttribute(value, name, attributeInfo.getType()).build());
                });
            }
        });
        return attributes;
    }

    public static Set<Attribute> buildGroupAttributes(GroupApi groupApi, Group group, Schema schema, Set<String> attributesToGet) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        attributesToGet.stream().filter(name -> !Name.NAME.equals(name) && !Uid.NAME.equals(name)).forEach(name -> {
            if (ID.equals(name)) {
                attributes.add(AttributeBuilder.build((String)name, (Object[])new Object[]{group.getId()}));
            } else if (DESCRIPTION.equals(name)) {
                attributes.add(AttributeBuilder.build((String)name, (Object[])new Object[]{group.getProfile().getDescription()}));
            } else if (LASTUPDATED.equals(name)) {
                attributes.add(OktaAttribute.buildAttribute(group.getLastUpdated() != null ? group.getLastUpdated().toInstant().toEpochMilli() : 0L, name, Long.class).build());
            }
        });
        return attributes;
    }

    public static Set<Attribute> buildApplicationAttributes(ApplicationApi applicationApi, Application application, Schema schema, Set<String> attributesToGet) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        ObjectClassInfo objectClassInfo = schema.findObjectClassInfo(OktaConnector.APPLICATION_NAME);
        attributesToGet.stream().filter(name -> !Name.NAME.equals(name) && !Uid.NAME.equals(name)).forEach(name -> {
            if (ID.equals(name)) {
                attributes.add(AttributeBuilder.build((String)name, (Object[])new Object[]{application.getId()}));
            } else if (STATUS.equals(name)) {
                AttributeBuilder attributeBuilder = new AttributeBuilder();
                attributeBuilder.setName(name);
                attributeBuilder.addValue(new Object[]{application.getStatus()});
                attributes.add(attributeBuilder.build());
            } else if (OperationalAttributes.ENABLE_NAME.equals(name) || STATUS.equals(name)) {
                AttributeBuilder attributeBuilder = new AttributeBuilder();
                attributeBuilder.setName(name);
                attributeBuilder.addValue(new Object[]{application.getStatus() == ApplicationLifecycleStatus.ACTIVE});
                attributes.add(attributeBuilder.build());
            } else if (LASTUPDATED.equals(name)) {
                attributes.add(OktaAttribute.buildAttribute(application.getLastUpdated() != null ? application.getLastUpdated().toInstant().toEpochMilli() : 0L, name, Long.class).build());
            } else {
                objectClassInfo.getAttributeInfo().stream().filter(attr -> attr.getName().equals(name)).findFirst().ifPresent(attributeInfo -> attributes.add(OktaAttribute.buildAttribute(application.getProfile().get(name), name, attributeInfo.getType()).build()));
            }
        });
        return attributes;
    }

    public static AttributeBuilder buildAttribute(Object value, String name, Class<?> clazz) {
        return OktaAttribute.buildAttribute(value, name, clazz, new AttributeBuilder());
    }

    public static AttributeBuilder buildAttribute(Object value, String name, Class<?> clazz, AttributeBuilder attributeBuilder) {
        if (value != null) {
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                attributeBuilder.addValue(new Object[]{Boolean.class.cast(value)});
            } else if (value instanceof List) {
                ArrayList list = new ArrayList((List)value);
                if (list.size() > 1) {
                    list.forEach(elem -> OktaAttribute.buildAttribute(elem, name, clazz, attributeBuilder));
                } else if (!list.isEmpty()) {
                    attributeBuilder.addValue(new Object[]{list.get(0).toString()});
                }
            } else {
                attributeBuilder.addValue(new Object[]{value.toString()});
            }
        }
        if (name != null) {
            attributeBuilder.setName(name);
        }
        return attributeBuilder;
    }

    public static String buildProfileAttrName(String name) {
        return "profile." + name;
    }

    public static boolean isDefaultEveryoneGroup(Group group) {
        return group.getType().name().equals("BUILT_IN") && group.getProfile().getName().equals("Everyone");
    }

    private OktaAttribute() {
    }
}

