/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class SinglePushJobDelegate
extends PushJobDelegate
implements SyncopeSinglePushExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;

    private void before(Provision provision, Connector connector, PushTaskTO pushTaskTO) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)provision.getResource());
        PushTask pushTask = (PushTask)this.entityFactory.newEntity(PushTask.class);
        pushTask.setResource(provision.getResource());
        pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
        pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
        pushTask.setPerformCreate(pushTaskTO.isPerformCreate());
        pushTask.setPerformUpdate(pushTaskTO.isPerformUpdate());
        pushTask.setPerformDelete(pushTaskTO.isPerformDelete());
        pushTask.setSyncStatus(pushTaskTO.isSyncStatus());
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
        this.profile.getActions().addAll(this.getPushActions(pushTaskTO.getActions().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList())));
        this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
        this.task = this.profile.getTask();
        for (PushActions action : this.profile.getActions()) {
            action.beforeAll(this.profile);
        }
    }

    public List<ProvisioningReport> push(Provision provision, Connector connector, Any<?> any, PushTaskTO pushTaskTO) throws JobExecutionException {
        try {
            UserPushResultHandler handler;
            this.before(provision, connector, pushTaskTO);
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = this.buildGroupHandler();
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            this.doHandle(Collections.singletonList(any), (SyncopePushResultHandler)handler, provision.getResource());
            for (PushActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            List list = this.profile.getResults();
            return list;
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
        finally {
            this.setStatus(null);
        }
    }

    public ProvisioningReport push(Provision provision, Connector connector, LinkedAccount account, PushTaskTO pushTaskTO) throws JobExecutionException {
        try {
            this.before(provision, connector, pushTaskTO);
            UserPushResultHandler handler = this.buildUserHandler();
            handler.setProfile(this.profile);
            handler.handle(account, provision);
            for (PushActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
            ProvisioningReport provisioningReport = (ProvisioningReport)this.profile.getResults().get(0);
            return provisioningReport;
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
        finally {
            this.setStatus(null);
        }
    }
}

