/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.PushCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.LinkingMappingItem;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.PushCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OutboundMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(OutboundMatcher.class);
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private VirAttrHandler virAttrHandler;
    private final Map<String, PropagationActions> perContextActions = new ConcurrentHashMap<String, PropagationActions>();
    private final Map<String, PushCorrelationRule> perContextPushCorrelationRules = new ConcurrentHashMap<String, PushCorrelationRule>();

    private Optional<PushCorrelationRule> rule(Provision provision) {
        Optional correlationRule = provision.getResource().getPushPolicy() == null ? Optional.empty() : provision.getResource().getPushPolicy().getCorrelationRule(provision.getAnyType());
        Optional rule = Optional.empty();
        if (correlationRule.isPresent()) {
            Implementation impl = ((PushCorrelationRuleEntity)correlationRule.get()).getImplementation();
            try {
                rule = ImplementationManager.buildPushCorrelationRule((Implementation)impl, () -> this.perContextPushCorrelationRules.get(impl.getKey()), instance -> this.perContextPushCorrelationRules.put(impl.getKey(), (PushCorrelationRule)instance));
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)impl, (Object)e);
            }
        }
        return rule;
    }

    public String getFIQL(ConnectorObject connectorObject, Provision provision) {
        return this.rule(provision).map(rule -> rule.getFiql(connectorObject, provision)).orElseGet(() -> (String)PushCorrelationRule.DEFAULT_FIQL_BUILDER.apply(connectorObject, provision));
    }

    public List<ConnectorObject> match(PropagationTask task, Connector connector, Provision provision, List<PropagationActions> actions, String connObjectKeyValue) {
        Optional<PushCorrelationRule> rule = this.rule(provision);
        boolean isLinkedAccount = task.getAnyTypeKind() == AnyTypeKind.USER && this.userDAO.linkedAccountExists(task.getEntityKey(), connObjectKeyValue);
        Any any = null;
        if (!isLinkedAccount) {
            any = this.anyUtilsFactory.getInstance(task.getAnyTypeKind()).dao().find(task.getEntityKey());
        }
        HashSet moreAttrsToGet = new HashSet();
        actions.forEach(action -> moreAttrsToGet.addAll(action.moreAttrsToGet(Optional.of(task), provision)));
        ArrayList<ConnectorObject> result = new ArrayList<ConnectorObject>();
        try {
            if (any != null && rule.isPresent()) {
                result.addAll(this.matchByCorrelationRule(connector, rule.get().getFilter(any, provision), provision, Optional.of(moreAttrsToGet.toArray(new String[0])), Optional.empty()));
            } else {
                MappingUtils.getConnObjectKeyItem(provision).ifPresent(connObjectKeyItem -> this.matchByConnObjectKeyValue(connector, (MappingItem)connObjectKeyItem, connObjectKeyValue, provision, Optional.of(moreAttrsToGet.toArray(new String[0])), Optional.empty()).ifPresent(result::add));
            }
        }
        catch (RuntimeException e) {
            LOG.error("Could not match {} with any existing {}", new Object[]{any, provision.getObjectClass(), e});
        }
        if (any != null && result.size() == 1) {
            this.virAttrHandler.setValues(any, (ConnectorObject)result.get(0));
        }
        return result;
    }

    protected List<PropagationActions> getPropagationActions(ExternalResource resource) {
        ArrayList<PropagationActions> result = new ArrayList<PropagationActions>();
        resource.getPropagationActions().forEach(impl -> {
            try {
                result.add((PropagationActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (PropagationActions)instance)));
            }
            catch (Exception e) {
                LOG.error("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    @Transactional(readOnly=true)
    public List<ConnectorObject> match(Connector connector, Any<?> any, Provision provision, Optional<String[]> moreAttrsToGet, LinkingMappingItem ... linkingItems) {
        Stream matgFromPropagationActions = this.getPropagationActions(provision.getResource()).stream().flatMap(a -> a.moreAttrsToGet(Optional.empty(), provision).stream());
        Optional<A[]> effectiveMATG = Optional.of(Stream.concat(moreAttrsToGet.map(Stream::of).orElse(Stream.empty()), matgFromPropagationActions).toArray(String[]::new));
        Optional<PushCorrelationRule> rule = this.rule(provision);
        ArrayList<ConnectorObject> result = new ArrayList<ConnectorObject>();
        try {
            if (rule.isPresent()) {
                result.addAll(this.matchByCorrelationRule(connector, rule.get().getFilter(any, provision), provision, effectiveMATG, ArrayUtils.isEmpty((Object[])linkingItems) ? Optional.empty() : Optional.of(Arrays.asList(linkingItems))));
            } else {
                Optional<? extends MappingItem> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
                Optional connObjectKeyValue = this.mappingManager.getConnObjectKeyValue(any, provision);
                if (connObjectKeyItem.isPresent() && connObjectKeyValue.isPresent()) {
                    this.matchByConnObjectKeyValue(connector, connObjectKeyItem.get(), (String)connObjectKeyValue.get(), provision, effectiveMATG, ArrayUtils.isEmpty((Object[])linkingItems) ? Optional.empty() : Optional.of(Arrays.asList(linkingItems))).ifPresent(result::add);
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error("Could not match {} with any existing {}", new Object[]{any, provision.getObjectClass(), e});
        }
        if (any != null && result.size() == 1) {
            this.virAttrHandler.setValues(any, (ConnectorObject)result.get(0));
        }
        return result;
    }

    private List<ConnectorObject> matchByCorrelationRule(Connector connector, Filter filter, Provision provision, Optional<String[]> moreAttrsToGet, Optional<Collection<LinkingMappingItem>> linkingItems) {
        Stream<LinkingMappingItem> items = Stream.concat(provision.getMapping().getItems().stream(), linkingItems.isPresent() ? linkingItems.get().stream() : this.virSchemaDAO.findByProvision(provision).stream().map(VirSchema::asLinkingMappingItem));
        final ArrayList<ConnectorObject> objs = new ArrayList<ConnectorObject>();
        try {
            connector.search(provision.getObjectClass(), filter, new SearchResultsHandler(){

                public void handleResult(SearchResult result) {
                }

                public boolean handle(ConnectorObject connectorObject) {
                    objs.add(connectorObject);
                    return true;
                }
            }, MappingUtils.buildOperationOptions(items, moreAttrsToGet.orElse(null)));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("Unexpected exception", (Throwable)ignore);
        }
        return objs;
    }

    @Transactional(readOnly=true)
    public Optional<ConnectorObject> matchByConnObjectKeyValue(Connector connector, MappingItem connObjectKeyItem, String connObjectKeyValue, Provision provision, Optional<String[]> moreAttrsToGet, Optional<Collection<LinkingMappingItem>> linkingItems) {
        Stream<LinkingMappingItem> items = Stream.concat(provision.getMapping().getItems().stream(), linkingItems.isPresent() ? linkingItems.get().stream() : this.virSchemaDAO.findByProvision(provision).stream().map(VirSchema::asLinkingMappingItem));
        ConnectorObject obj = null;
        try {
            obj = connector.getObject(provision.getObjectClass(), AttributeBuilder.build((String)connObjectKeyItem.getExtAttrName(), (Object[])new Object[]{connObjectKeyValue}), provision.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions(items, moreAttrsToGet.orElse(null)));
        }
        catch (TimeoutException toe) {
            LOG.debug("Request timeout", (Throwable)toe);
            throw toe;
        }
        catch (RuntimeException ignore) {
            LOG.debug("While resolving {}", (Object)connObjectKeyValue, (Object)ignore);
        }
        return Optional.ofNullable(obj);
    }
}

