/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class LDAPPasswordPullActions
implements PullActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPPasswordPullActions.class);
    @Autowired
    protected UserDAO userDAO;

    public Set<String> moreAttrsToGet(ProvisioningProfile<?, ?> profile, Provision provision) {
        if (AnyTypeKind.USER == provision.getAnyType().getKind()) {
            return Collections.singleton(OperationalAttributes.PASSWORD_NAME);
        }
        return super.moreAttrsToGet(profile, provision);
    }

    private static Optional<Pair<String, CipherAlgorithm>> parseEncodedPassword(String password) {
        if (password != null && password.startsWith("{")) {
            String digest = Optional.ofNullable(password.substring(1, password.indexOf(125))).map(String::toUpperCase).orElse(null);
            int closingBracketIndex = password.indexOf(125);
            try {
                return Optional.of(Pair.of((Object)password.substring(closingBracketIndex + 1), (Object)CipherAlgorithm.valueOf((String)digest)));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cipher algorithm not allowed: {}", (Object)digest, (Object)e);
            }
        }
        return Optional.empty();
    }

    @Transactional
    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        GuardedString passwordAttr;
        User user;
        if (entity instanceof UserTO && (user = (User)this.userDAO.find(entity.getKey())) != null && (passwordAttr = AttributeUtil.getPasswordValue((Set)delta.getObject().getAttributes())) != null) {
            LDAPPasswordPullActions.parseEncodedPassword(SecurityUtil.decrypt((GuardedString)passwordAttr)).ifPresent(encoded -> {
                byte[] encodedPasswordBytes = Base64.getDecoder().decode(((String)encoded.getLeft()).getBytes());
                String encodedHexStr = DatatypeConverter.printHexBinary((byte[])encodedPasswordBytes).toUpperCase();
                user.setEncodedPassword(encodedHexStr, (CipherAlgorithm)encoded.getRight());
            });
        }
    }
}

