/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.LinkedAccountPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.PullMatch;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPullResultHandler;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultUserPullResultHandler
extends AbstractPullResultHandler
implements UserPullResultHandler {
    @Autowired
    private UserProvisioningManager userProvisioningManager;

    @Override
    protected AnyUtils getAnyUtils() {
        return this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
    }

    @Override
    protected String getName(AnyTO anyTO) {
        return ((UserTO)UserTO.class.cast(anyTO)).getUsername();
    }

    @Override
    protected ProvisioningManager<?, ?> getProvisioningManager() {
        return this.userProvisioningManager;
    }

    @Override
    protected AnyTO getAnyTO(Any<?> any) {
        return this.userDataBinder.getUserTO((User)any, true);
    }

    @Override
    protected WorkflowResult<? extends AnyPatch> update(AnyPatch patch) {
        UserWorkflowResult update = this.uwfAdapter.update((UserPatch)patch);
        return new WorkflowResult(((Pair)update.getResult()).getLeft(), update.getPropByRes(), update.getPerformedTasks());
    }

    public Boolean enabled(SyncDelta delta) {
        return ((PullTask)this.profile.getTask()).isSyncStatus() ? AttributeUtil.isEnabled((ConnectorObject)delta.getObject()) : null;
    }

    @Override
    protected AnyTO doCreate(AnyTO anyTO, SyncDelta delta) {
        Pair created = this.userProvisioningManager.create((UserTO)UserTO.class.cast(anyTO), true, true, this.enabled(delta), Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        return this.userDataBinder.getUserTO((String)created.getKey());
    }

    @Override
    protected AnyPatch doUpdate(AnyTO before, AnyPatch anyPatch, SyncDelta delta, ProvisioningReport result) {
        Pair updated = this.userProvisioningManager.update((UserPatch)UserPatch.class.cast(anyPatch), result, this.enabled(delta), Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
        this.createRemediationIfNeeded(anyPatch, delta, result);
        return (AnyPatch)updated.getLeft();
    }

    @Override
    protected void handleLinkedAccounts(SyncDelta delta, List<PullMatch> matches, Provision provision) throws JobExecutionException {
        for (PullMatch match : matches) {
            if (match.getAny() == null) {
                LOG.error("Could not find linking user, cannot process match {}", (Object)match);
                return;
            }
            User user = (User)match.getAny();
            Optional found = user.getLinkedAccount(provision.getResource().getKey(), delta.getUid().getUidValue());
            if (found.isPresent()) {
                LinkedAccount account = (LinkedAccount)found.get();
                block0 : switch (delta.getDeltaType()) {
                    case CREATE: 
                    case UPDATE: 
                    case CREATE_OR_UPDATE: {
                        switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                            case UPDATE: {
                                this.update(delta, account, provision).ifPresent(this.profile.getResults()::add);
                                break block0;
                            }
                            case DEPROVISION: 
                            case UNASSIGN: {
                                this.deprovision(((PullTask)this.profile.getTask()).getMatchingRule(), delta, account).ifPresent(this.profile.getResults()::add);
                                break block0;
                            }
                            case LINK: 
                            case UNLINK: {
                                LOG.warn("{} not applicable to linked accounts, ignoring", (Object)((PullTask)this.profile.getTask()).getMatchingRule());
                                break block0;
                            }
                            case IGNORE: {
                                this.profile.getResults().add(this.ignore(delta, account, true, new String[0]));
                                break block0;
                            }
                        }
                        break;
                    }
                    case DELETE: {
                        this.delete(delta, account, provision).ifPresent(this.profile.getResults()::add);
                        break;
                    }
                }
                continue;
            }
            block10 : switch (delta.getDeltaType()) {
                case CREATE: 
                case UPDATE: 
                case CREATE_OR_UPDATE: {
                    LinkedAccountTO accountTO = new LinkedAccountTO();
                    accountTO.setConnObjectKeyValue(delta.getUid().getUidValue());
                    accountTO.setResource(provision.getResource().getKey());
                    switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: 
                        case PROVISION: {
                            this.provision(((PullTask)this.profile.getTask()).getUnmatchingRule(), delta, user, accountTO, provision).ifPresent(this.profile.getResults()::add);
                            break block10;
                        }
                        case IGNORE: {
                            this.profile.getResults().add(this.ignore(delta, null, false, new String[0]));
                            break block10;
                        }
                    }
                    break;
                }
                case DELETE: {
                    this.end(AnyTypeKind.USER, ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
                    LOG.debug("No match found for deletion");
                    break;
                }
            }
        }
    }

    protected Optional<ProvisioningReport> deprovision(MatchingRule matchingRule, SyncDelta delta, LinkedAccount account) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(AnyTypeKind.USER, MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Optional.empty();
        }
        LOG.debug("About to deprovision {}", (Object)account);
        ProvisioningReport report = new ProvisioningReport();
        report.setOperation(ResourceOperation.DELETE);
        report.setAnyType(MatchType.LINKED_ACCOUNT.name());
        report.setStatus(ProvisioningReport.Status.SUCCESS);
        report.setKey(account.getKey());
        report.setUidValue(account.getConnObjectKeyValue());
        LinkedAccountTO before = this.userDataBinder.getLinkedAccountTO(account);
        if (!this.profile.isDryRun()) {
            AuditElements.Result resultStatus;
            Object output = before;
            try {
                if (matchingRule == MatchingRule.UNASSIGN) {
                    for (PullActions action : this.profile.getActions()) {
                        action.beforeUnassign(this.profile, delta, (EntityTO)before);
                    }
                } else if (matchingRule == MatchingRule.DEPROVISION) {
                    for (PullActions action : this.profile.getActions()) {
                        action.beforeDeprovision(this.profile, delta, (EntityTO)before);
                    }
                }
                PropagationByResource propByLinkedAccount = new PropagationByResource();
                propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue()));
                this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(AnyTypeKind.USER, account.getOwner().getKey(), null, propByLinkedAccount, null), false);
                for (PullActions action : this.profile.getActions()) {
                    action.after(this.profile, delta, (EntityTO)before, report);
                }
                resultStatus = AuditElements.Result.SUCCESS;
                LOG.debug("Linked account {} successfully updated", (Object)account.getConnObjectKeyValue());
            }
            catch (PropagationException e) {
                LOG.error("Could not propagate linked acccount {}", (Object)account.getConnObjectKeyValue());
                output = e;
                resultStatus = AuditElements.Result.FAILURE;
            }
            catch (Exception e) {
                this.throwIgnoreProvisionException(delta, e);
                report.setStatus(ProvisioningReport.Status.FAILURE);
                report.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOG.error("Could not update linked account {}", (Object)account, (Object)e);
                output = e;
                resultStatus = AuditElements.Result.FAILURE;
            }
            this.end(AnyTypeKind.USER, MatchingRule.toEventName((MatchingRule)matchingRule), resultStatus, before, output, delta, new Object[0]);
        }
        return Optional.of(report);
    }

    protected Optional<ProvisioningReport> provision(UnmatchingRule rule, SyncDelta delta, User user, LinkedAccountTO accountTO, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.end(AnyTypeKind.USER, UnmatchingRule.toEventName((UnmatchingRule)rule), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Optional.empty();
        }
        LOG.debug("About to create {}", (Object)accountTO);
        ProvisioningReport report = new ProvisioningReport();
        report.setOperation(ResourceOperation.CREATE);
        report.setName(accountTO.getConnObjectKeyValue());
        report.setUidValue(accountTO.getConnObjectKeyValue());
        report.setAnyType(MatchType.LINKED_ACCOUNT.name());
        report.setStatus(ProvisioningReport.Status.SUCCESS);
        if (this.profile.isDryRun()) {
            report.setKey(null);
            this.end(AnyTypeKind.USER, UnmatchingRule.toEventName((UnmatchingRule)rule), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
        } else {
            AuditElements.Result resultStatus;
            Throwable output;
            block13: {
                UserTO owner = this.userDataBinder.getUserTO(user, false);
                UserTO connObject = (UserTO)this.connObjectUtils.getAnyTO(delta.getObject(), (PullTask)this.profile.getTask(), provision, false);
                if (connObject.getUsername().equals(owner.getUsername())) {
                    accountTO.setUsername(null);
                } else if (!connObject.getUsername().equals(accountTO.getUsername())) {
                    accountTO.setUsername(connObject.getUsername());
                }
                if (connObject.getPassword() != null) {
                    accountTO.setPassword(connObject.getPassword());
                }
                accountTO.setSuspended(BooleanUtils.isTrue((Boolean)BooleanUtils.negate((Boolean)this.enabled(delta))));
                connObject.getPlainAttrs().forEach(connObjectAttr -> {
                    Optional ownerAttr = owner.getPlainAttr(connObjectAttr.getSchema());
                    if (ownerAttr.isPresent() && ((AttrTO)ownerAttr.get()).getValues().equals(connObjectAttr.getValues())) {
                        accountTO.getPlainAttrs().removeIf(attr -> connObjectAttr.getSchema().equals(attr.getSchema()));
                    } else {
                        accountTO.getPlainAttrs().add(connObjectAttr);
                    }
                });
                for (PullActions action : this.profile.getActions()) {
                    if (rule == UnmatchingRule.ASSIGN) {
                        action.beforeAssign(this.profile, delta, (EntityTO)accountTO);
                        continue;
                    }
                    if (rule != UnmatchingRule.PROVISION) continue;
                    action.beforeProvision(this.profile, delta, (EntityTO)accountTO);
                }
                report.setName(accountTO.getConnObjectKeyValue());
                UserPatch patch = new UserPatch();
                patch.setKey(user.getKey());
                patch.getLinkedAccounts().add(((LinkedAccountPatch.Builder)new LinkedAccountPatch.Builder().operation(PatchOperation.ADD_REPLACE)).linkedAccountTO(accountTO).build());
                try {
                    this.userProvisioningManager.update(patch, report, null, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
                    LinkedAccountTO created = ((User)this.userDAO.find(patch.getKey())).getLinkedAccount(accountTO.getResource(), accountTO.getConnObjectKeyValue()).map(acct -> this.userDataBinder.getLinkedAccountTO(acct)).orElse(null);
                    output = created;
                    resultStatus = AuditElements.Result.SUCCESS;
                    for (PullActions action : this.profile.getActions()) {
                        action.after(this.profile, delta, (EntityTO)created, report);
                    }
                    LOG.debug("Linked account {} successfully created", (Object)accountTO.getConnObjectKeyValue());
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate linked acccount {}", (Object)accountTO.getConnObjectKeyValue());
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    report.setStatus(ProvisioningReport.Status.FAILURE);
                    report.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not create linked account {} ", (Object)accountTO.getConnObjectKeyValue(), (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                    if (!((PullTask)this.profile.getTask()).isRemediation()) break block13;
                    this.createRemediation(provision.getAnyType(), (AnyPatch)patch, (PullTask)this.profile.getTask(), report, delta);
                }
            }
            this.end(AnyTypeKind.USER, UnmatchingRule.toEventName((UnmatchingRule)rule), resultStatus, null, output, delta, new Object[0]);
        }
        return Optional.of(report);
    }

    protected Optional<ProvisioningReport> update(SyncDelta delta, LinkedAccount account, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(AnyTypeKind.USER, MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Optional.empty();
        }
        LOG.debug("About to update {}", (Object)account);
        ProvisioningReport report = new ProvisioningReport();
        report.setOperation(ResourceOperation.UPDATE);
        report.setKey(account.getKey());
        report.setUidValue(account.getConnObjectKeyValue());
        report.setName(account.getConnObjectKeyValue());
        report.setAnyType(MatchType.LINKED_ACCOUNT.name());
        report.setStatus(ProvisioningReport.Status.SUCCESS);
        if (!this.profile.isDryRun()) {
            Throwable output;
            AuditElements.Result resultStatus;
            LinkedAccountTO before;
            block11: {
                before = this.userDataBinder.getLinkedAccountTO(account);
                UserTO owner = this.userDataBinder.getUserTO(account.getOwner(), false);
                UserTO connObject = (UserTO)this.connObjectUtils.getAnyTO(delta.getObject(), (PullTask)this.profile.getTask(), provision, false);
                LinkedAccountTO update = this.userDataBinder.getLinkedAccountTO(account);
                if (connObject.getUsername().equals(owner.getUsername())) {
                    update.setUsername(null);
                } else if (!connObject.getUsername().equals(update.getUsername())) {
                    update.setUsername(connObject.getUsername());
                }
                if (connObject.getPassword() != null) {
                    update.setPassword(connObject.getPassword());
                }
                update.setSuspended(BooleanUtils.isTrue((Boolean)BooleanUtils.negate((Boolean)this.enabled(delta))));
                HashSet attrsToRemove = new HashSet();
                connObject.getPlainAttrs().forEach(connObjectAttr -> {
                    Optional ownerAttr = owner.getPlainAttr(connObjectAttr.getSchema());
                    if (ownerAttr.isPresent() && ((AttrTO)ownerAttr.get()).getValues().equals(connObjectAttr.getValues())) {
                        attrsToRemove.add(connObjectAttr.getSchema());
                    } else {
                        Optional updateAttr = update.getPlainAttr(connObjectAttr.getSchema());
                        if (!updateAttr.isPresent() || !((AttrTO)updateAttr.get()).getValues().equals(connObjectAttr.getValues())) {
                            attrsToRemove.add(connObjectAttr.getSchema());
                            update.getPlainAttrs().add(connObjectAttr);
                        }
                    }
                });
                update.getPlainAttrs().removeIf(attr -> attrsToRemove.contains(attr.getSchema()));
                UserPatch patch = new UserPatch();
                patch.setKey(account.getOwner().getKey());
                patch.getLinkedAccounts().add(((LinkedAccountPatch.Builder)new LinkedAccountPatch.Builder().operation(PatchOperation.ADD_REPLACE)).linkedAccountTO(update).build());
                for (PullActions action : this.profile.getActions()) {
                    action.beforeUpdate(this.profile, delta, (EntityTO)before, (AnyPatch)patch);
                }
                try {
                    this.userProvisioningManager.update(patch, report, null, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
                    resultStatus = AuditElements.Result.SUCCESS;
                    LinkedAccountTO updated = ((User)this.userDAO.find(patch.getKey())).getLinkedAccount(account.getResource().getKey(), account.getConnObjectKeyValue()).map(acct -> this.userDataBinder.getLinkedAccountTO(acct)).orElse(null);
                    output = updated;
                    resultStatus = AuditElements.Result.SUCCESS;
                    for (PullActions action : this.profile.getActions()) {
                        action.after(this.profile, delta, (EntityTO)updated, report);
                    }
                    LOG.debug("Linked account {} successfully updated", (Object)account.getConnObjectKeyValue());
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate linked acccount {}", (Object)account.getConnObjectKeyValue());
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    report.setStatus(ProvisioningReport.Status.FAILURE);
                    report.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update linked account {}", (Object)account, (Object)e);
                    output = e;
                    resultStatus = AuditElements.Result.FAILURE;
                    if (!((PullTask)this.profile.getTask()).isRemediation()) break block11;
                    this.createRemediation(provision.getAnyType(), (AnyPatch)patch, (PullTask)this.profile.getTask(), report, delta);
                }
            }
            this.end(AnyTypeKind.USER, MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta, new Object[0]);
        }
        return Optional.of(report);
    }

    protected Optional<ProvisioningReport> delete(SyncDelta delta, LinkedAccount account, Provision provision) throws JobExecutionException {
        ProvisioningReport report;
        block7: {
            if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
                LOG.debug("PullTask not configured for delete");
                this.end(AnyTypeKind.USER, ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
                return Optional.empty();
            }
            LOG.debug("About to delete {}", (Object)account);
            AuditElements.Result resultStatus = AuditElements.Result.FAILURE;
            report = new ProvisioningReport();
            try {
                Exception output;
                LinkedAccountTO before;
                block8: {
                    report.setKey(account.getKey());
                    report.setName(account.getConnObjectKeyValue());
                    report.setUidValue(account.getConnObjectKeyValue());
                    report.setOperation(ResourceOperation.DELETE);
                    report.setAnyType(MatchType.LINKED_ACCOUNT.name());
                    report.setStatus(ProvisioningReport.Status.SUCCESS);
                    if (this.profile.isDryRun()) break block7;
                    before = this.userDataBinder.getLinkedAccountTO(account);
                    for (Object action : this.profile.getActions()) {
                        action.beforeDelete(this.profile, delta, (EntityTO)before);
                    }
                    UserPatch patch = new UserPatch();
                    patch.setKey(account.getOwner().getKey());
                    patch.getLinkedAccounts().add(((LinkedAccountPatch.Builder)new LinkedAccountPatch.Builder().operation(PatchOperation.DELETE)).linkedAccountTO(before).build());
                    try {
                        this.userProvisioningManager.update(patch, report, null, Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
                        resultStatus = AuditElements.Result.SUCCESS;
                        output = null;
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)before, report);
                        }
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        report.setStatus(ProvisioningReport.Status.FAILURE);
                        report.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not delete linked account {}", (Object)account, (Object)e);
                        output = e;
                        if (!((PullTask)this.profile.getTask()).isRemediation()) break block8;
                        this.createRemediation(provision.getAnyType(), (AnyPatch)patch, (PullTask)this.profile.getTask(), report, delta);
                    }
                }
                this.end(AnyTypeKind.USER, ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta, new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Could not delete linked account {}", (Object)account, (Object)e);
            }
        }
        return Optional.of(report);
    }

    protected ProvisioningReport ignore(SyncDelta delta, LinkedAccount account, boolean matching, String ... message) throws JobExecutionException {
        LOG.debug("Linked account to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        ProvisioningReport report = new ProvisioningReport();
        report.setName(delta.getUid().getUidValue());
        report.setUidValue(delta.getUid().getUidValue());
        report.setOperation(ResourceOperation.NONE);
        report.setAnyType(MatchType.LINKED_ACCOUNT.name());
        report.setStatus(ProvisioningReport.Status.SUCCESS);
        if (message != null && message.length >= 1) {
            report.setMessage(message[0]);
        }
        if (account != null) {
            report.setKey(account.getKey());
        }
        this.end(AnyTypeKind.USER, matching ? MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
        return report;
    }
}

