/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PullMatch;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Remediation;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheKey;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractSyncopeResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractPullResultHandler
extends AbstractSyncopeResultHandler<PullTask, PullActions>
implements SyncopePullResultHandler {
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected RemediationDAO remediationDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected VirAttrCache virAttrCache;
    @Autowired
    protected EntityFactory entityFactory;
    protected SyncopePullExecutor executor;
    protected AuditElements.Result latestResult;

    protected abstract String getName(AnyTO var1);

    protected abstract ProvisioningManager<?, ?> getProvisioningManager();

    protected abstract AnyTO doCreate(AnyTO var1, SyncDelta var2);

    protected abstract AnyPatch doUpdate(AnyTO var1, AnyPatch var2, SyncDelta var3, ProvisioningReport var4);

    public void setPullExecutor(SyncopePullExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(SyncDelta delta) {
        Provision provision = null;
        try {
            boolean shouldContinue;
            provision = (Provision)((PullTask)this.profile.getTask()).getResource().getProvision(delta.getObject().getObjectClass()).orElseThrow(() -> new JobExecutionException("No provision found on " + ((PullTask)this.profile.getTask()).getResource() + " for " + delta.getObject().getObjectClass()));
            this.doHandle(delta, provision);
            this.executor.reportHandled(delta.getObjectClass(), delta.getObject().getName());
            LOG.debug("Successfully handled {}", (Object)delta);
            if (((PullTask)this.profile.getTask()).getPullMode() != PullMode.INCREMENTAL) {
                if (this.executor.wasInterruptRequested()) {
                    LOG.debug("Pull interrupted");
                    this.executor.setInterrupted();
                    return false;
                }
                return true;
            }
            AbstractPullResultHandler abstractPullResultHandler = this;
            synchronized (abstractPullResultHandler) {
                shouldContinue = this.latestResult == AuditElements.Result.SUCCESS;
                this.latestResult = null;
            }
            if (shouldContinue) {
                this.executor.setLatestSyncToken(delta.getObjectClass(), delta.getToken());
            }
            if (this.executor.wasInterruptRequested()) {
                LOG.debug("Pull interrupted");
                this.executor.setInterrupted();
                return false;
            }
            return shouldContinue;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = new ProvisioningReport();
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setAnyType(provision == null ? this.getAnyUtils().anyTypeKind().name() : provision.getAnyType().getKey());
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setMessage(e.getMessage());
            ignoreResult.setKey(null);
            ignoreResult.setUidValue(delta.getUid().getUidValue());
            ignoreResult.setName(delta.getObject().getName().getNameValue());
            this.profile.getResults().add(ignoreResult);
            LOG.warn("Ignoring during pull", (Throwable)e);
            this.executor.setLatestSyncToken(delta.getObjectClass(), delta.getToken());
            this.executor.reportHandled(delta.getObjectClass(), delta.getObject().getName());
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Pull failed", (Throwable)e);
            return false;
        }
    }

    protected List<ProvisioningReport> provision(UnmatchingRule rule, SyncDelta delta, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.end(provision.getAnyType().getKind(), UnmatchingRule.toEventName((UnmatchingRule)rule), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        Object anyTO = this.connObjectUtils.getAnyTO(delta.getObject(), (PullTask)this.profile.getTask(), provision, true);
        if (rule == UnmatchingRule.ASSIGN) {
            anyTO.getResources().add(((PullTask)this.profile.getTask()).getResource().getKey());
        }
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType(provision.getAnyType().getKey());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(this.getName((AnyTO)anyTO));
        result.setUidValue(delta.getUid().getUidValue());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.end(provision.getAnyType().getKind(), UnmatchingRule.toEventName((UnmatchingRule)rule), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
        } else {
            AuditElements.Result resultStatus;
            Object output;
            try {
                AnyTO created;
                for (PullActions action : this.profile.getActions()) {
                    if (rule == UnmatchingRule.ASSIGN) {
                        action.beforeAssign(this.profile, delta, anyTO);
                        continue;
                    }
                    if (rule != UnmatchingRule.PROVISION) continue;
                    action.beforeProvision(this.profile, delta, anyTO);
                }
                result.setName(this.getName((AnyTO)anyTO));
                output = created = this.doCreate((AnyTO)anyTO, delta);
                result.setKey(created.getKey());
                result.setName(this.getName(created));
                resultStatus = AuditElements.Result.SUCCESS;
                for (PullActions action : this.profile.getActions()) {
                    action.after(this.profile, delta, (EntityTO)created, result);
                }
                LOG.debug("{} {} successfully created", (Object)created.getType(), (Object)created.getKey());
            }
            catch (PropagationException e) {
                LOG.error("Could not propagate {} {}", new Object[]{anyTO.getType(), delta.getUid().getUidValue(), e});
                output = e;
                resultStatus = AuditElements.Result.FAILURE;
            }
            catch (Exception e) {
                this.throwIgnoreProvisionException(delta, e);
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOG.error("Could not create {} {} ", new Object[]{anyTO.getType(), delta.getUid().getUidValue(), e});
                output = e;
                if (((PullTask)this.profile.getTask()).isRemediation()) {
                    resultStatus = AuditElements.Result.SUCCESS;
                    this.createRemediation(provision.getAnyType(), null, (AnyTO)anyTO, null, this.taskDAO.exists(TaskType.PULL, ((PullTask)this.profile.getTask()).getKey()) ? (PullTask)this.profile.getTask() : null, result, delta);
                }
                resultStatus = AuditElements.Result.FAILURE;
            }
            this.end(provision.getAnyType().getKind(), UnmatchingRule.toEventName((UnmatchingRule)rule), resultStatus, null, output, delta, new Object[0]);
        }
        return Collections.singletonList(result);
    }

    protected void throwIgnoreProvisionException(SyncDelta delta, Exception exception) throws JobExecutionException {
        if (exception instanceof IgnoreProvisionException) {
            throw (IgnoreProvisionException)((Object)IgnoreProvisionException.class.cast(exception));
        }
        IgnoreProvisionException ipe = null;
        for (PullActions action : this.profile.getActions()) {
            if (ipe != null) continue;
            ipe = action.onError(this.profile, delta, exception);
        }
        if (ipe != null) {
            throw ipe;
        }
    }

    protected List<ProvisioningReport> update(SyncDelta delta, List<PullMatch> matches, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType().getKind(), MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        LOG.debug("About to update {}", matches);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (PullMatch match : matches) {
            LOG.debug("About to update {}", (Object)match);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.UPDATE);
            result.setAnyType(provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(match.getAny().getKey());
            result.setUidValue(delta.getUid().getUidValue());
            AnyTO before = this.getAnyTO(match.getAny());
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType().getKey(), match));
            } else {
                result.setName(this.getName(before));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                AnyPatch effectivePatch = null;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    AnyPatch anyPatch = null;
                    try {
                        anyPatch = (AnyPatch)this.connObjectUtils.getAnyPatch(before.getKey(), delta.getObject(), before, (PullTask)this.profile.getTask(), provision);
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, delta, (EntityTO)before, anyPatch);
                        }
                        effectivePatch = this.doUpdate(before, anyPatch, delta, result);
                        AnyTO updated = AnyOperations.patch((AnyTO)before, (AnyPatch)effectivePatch);
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)updated, result);
                        }
                        output = updated;
                        resultStatus = AuditElements.Result.SUCCESS;
                        result.setName(this.getName(updated));
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType().getKey(), (Object)match);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        if (((PullTask)this.profile.getTask()).isRemediation()) {
                            resultStatus = AuditElements.Result.SUCCESS;
                            this.createRemediation(provision.getAnyType(), anyPatch, this.taskDAO.exists(TaskType.PULL, ((PullTask)this.profile.getTask()).getKey()) ? (PullTask)this.profile.getTask() : null, result, delta);
                        }
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.end(provision.getAnyType().getKind(), MatchingRule.toEventName((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta, effectivePatch);
            }
            results.add(result);
        }
        return results;
    }

    protected List<ProvisioningReport> deprovision(MatchingRule matchingRule, SyncDelta delta, List<PullMatch> matches, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType().getKind(), MatchingRule.toEventName((MatchingRule)matchingRule), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        LOG.debug("About to deprovision {}", matches);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (PullMatch match : matches) {
            LOG.debug("About to unassign resource {}", (Object)match);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.DELETE);
            result.setAnyType(provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(match.getAny().getKey());
            result.setUidValue(delta.getUid().getUidValue());
            AnyTO before = this.getAnyTO(match.getAny());
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType().getKey(), match));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    result.setName(this.getName(before));
                    try {
                        if (matchingRule == MatchingRule.UNASSIGN) {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeUnassign(this.profile, delta, (EntityTO)before);
                            }
                        } else if (matchingRule == MatchingRule.DEPROVISION) {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeDeprovision(this.profile, delta, (EntityTO)before);
                            }
                        }
                        PropagationByResource propByRes = new PropagationByResource();
                        propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)provision.getResource().getKey()));
                        this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(provision.getAnyType().getKind(), match.getAny().getKey(), propByRes, null, null), false);
                        AnyPatch anyPatch = null;
                        if (matchingRule == MatchingRule.UNASSIGN) {
                            anyPatch = this.getAnyUtils().newAnyPatch(match.getAny().getKey());
                            anyPatch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)((PullTask)this.profile.getTask()).getResource().getKey())).build());
                        }
                        output = anyPatch == null ? this.getAnyTO(match.getAny()) : this.doUpdate(before, anyPatch, delta, result);
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)AnyTO.class.cast(output), result);
                        }
                        resultStatus = AuditElements.Result.SUCCESS;
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType().getKey(), (Object)match);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.end(provision.getAnyType().getKind(), MatchingRule.toEventName((MatchingRule)matchingRule), resultStatus, before, output, delta, new Object[0]);
            }
            results.add(result);
        }
        return results;
    }

    protected List<ProvisioningReport> link(SyncDelta delta, List<PullMatch> matches, Provision provision, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType().getKind(), unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        LOG.debug("About to update {}", matches);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        for (PullMatch match : matches) {
            LOG.debug("About to unassign resource {}", (Object)match);
            ProvisioningReport result = new ProvisioningReport();
            result.setOperation(ResourceOperation.NONE);
            result.setAnyType(provision.getAnyType().getKey());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setKey(match.getAny().getKey());
            result.setUidValue(delta.getUid().getUidValue());
            AnyTO before = this.getAnyTO(match.getAny());
            if (before == null) {
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType().getKey(), match));
            }
            if (!this.profile.isDryRun()) {
                Throwable output;
                AuditElements.Result resultStatus;
                AnyPatch effectivePatch = null;
                if (before == null) {
                    resultStatus = AuditElements.Result.FAILURE;
                    output = null;
                } else {
                    result.setName(this.getName(before));
                    try {
                        if (unlink) {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeUnlink(this.profile, delta, (EntityTO)before);
                            }
                        } else {
                            for (PullActions action : this.profile.getActions()) {
                                action.beforeLink(this.profile, delta, (EntityTO)before);
                            }
                        }
                        AnyPatch anyPatch = this.getAnyUtils().newAnyPatch(before.getKey());
                        anyPatch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value((Object)((PullTask)this.profile.getTask()).getResource().getKey())).build());
                        effectivePatch = (AnyPatch)this.update(anyPatch).getResult();
                        output = AnyOperations.patch((AnyTO)before, (AnyPatch)effectivePatch);
                        for (PullActions action : this.profile.getActions()) {
                            action.after(this.profile, delta, (EntityTO)AnyTO.class.cast(output), result);
                        }
                        resultStatus = AuditElements.Result.SUCCESS;
                        LOG.debug("{} {} successfully updated", (Object)provision.getAnyType().getKey(), (Object)match);
                    }
                    catch (PropagationException e) {
                        LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not update {} {}", new Object[]{provision.getAnyType().getKey(), delta.getUid().getUidValue(), e});
                        output = e;
                        resultStatus = AuditElements.Result.FAILURE;
                    }
                }
                this.end(provision.getAnyType().getKind(), unlink ? MatchingRule.toEventName((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toEventName((MatchingRule)MatchingRule.LINK), resultStatus, before, output, delta, effectivePatch);
            }
            results.add(result);
        }
        return results;
    }

    protected List<ProvisioningReport> delete(SyncDelta delta, List<PullMatch> matches, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
            LOG.debug("PullTask not configured for delete");
            this.end(provision.getAnyType().getKind(), ResourceOperation.DELETE.name().toLowerCase(), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
            return Collections.emptyList();
        }
        LOG.debug("About to delete {}", matches);
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        matches.forEach(match -> {
            AuditElements.Result resultStatus = AuditElements.Result.FAILURE;
            ProvisioningReport result = new ProvisioningReport();
            try {
                AnyTO before = this.getAnyTO(match.getAny());
                result.setKey(match.getAny().getKey());
                result.setName(this.getName(before));
                result.setOperation(ResourceOperation.DELETE);
                result.setAnyType(provision.getAnyType().getKey());
                result.setStatus(ProvisioningReport.Status.SUCCESS);
                result.setUidValue(delta.getUid().getUidValue());
                if (!this.profile.isDryRun()) {
                    Exception output;
                    block9: {
                        for (PullActions action : this.profile.getActions()) {
                            action.beforeDelete(this.profile, delta, (EntityTO)before);
                        }
                        try {
                            this.getProvisioningManager().delete(match.getAny().getKey(), Collections.singleton(((PullTask)this.profile.getTask()).getResource().getKey()), true);
                            output = null;
                            resultStatus = AuditElements.Result.SUCCESS;
                            for (PullActions action : this.profile.getActions()) {
                                action.after(this.profile, delta, (EntityTO)before, result);
                            }
                        }
                        catch (Exception e) {
                            this.throwIgnoreProvisionException(delta, e);
                            result.setStatus(ProvisioningReport.Status.FAILURE);
                            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                            LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType().getKey(), match, e});
                            output = e;
                            if (!((PullTask)this.profile.getTask()).isRemediation()) break block9;
                            resultStatus = AuditElements.Result.SUCCESS;
                            this.createRemediation(provision.getAnyType(), match.getAny().getKey(), null, null, this.taskDAO.exists(TaskType.PULL, ((PullTask)this.profile.getTask()).getKey()) ? (PullTask)this.profile.getTask() : null, result, delta);
                        }
                    }
                    this.end(provision.getAnyType().getKind(), ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta, new Object[0]);
                }
                results.add(result);
            }
            catch (NotFoundException e) {
                LOG.error("Could not find {} {}", new Object[]{provision.getAnyType().getKey(), match, e});
            }
            catch (DelegatedAdministrationException e) {
                LOG.error("Not allowed to read {} {}", new Object[]{provision.getAnyType().getKey(), match, e});
            }
            catch (Exception e) {
                LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType().getKey(), match, e});
            }
        });
        return results;
    }

    protected List<ProvisioningReport> ignore(SyncDelta delta, List<PullMatch> matches, Provision provision, boolean matching, String ... message) throws JobExecutionException {
        LOG.debug("Any to ignore {}", (Object)delta.getObject().getUid().getUidValue());
        ArrayList<ProvisioningReport> results = new ArrayList<ProvisioningReport>();
        if (matches == null) {
            ProvisioningReport report = new ProvisioningReport();
            report.setKey(null);
            report.setName(delta.getObject().getUid().getUidValue());
            report.setOperation(ResourceOperation.NONE);
            report.setAnyType(provision.getAnyType().getKey());
            report.setStatus(ProvisioningReport.Status.SUCCESS);
            report.setUidValue(delta.getUid().getUidValue());
            if (message != null && message.length >= 1) {
                report.setMessage(message[0]);
            }
            results.add(report);
        } else {
            matches.forEach(match -> {
                ProvisioningReport report = new ProvisioningReport();
                report.setKey(match.getAny().getKey());
                report.setName(delta.getObject().getUid().getUidValue());
                report.setOperation(ResourceOperation.NONE);
                report.setAnyType(provision.getAnyType().getKey());
                report.setStatus(ProvisioningReport.Status.SUCCESS);
                report.setUidValue(delta.getUid().getUidValue());
                if (message != null && message.length >= 1) {
                    report.setMessage(message[0]);
                }
                results.add(report);
            });
        }
        this.end(provision.getAnyType().getKind(), matching ? MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toEventName((UnmatchingRule)UnmatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
        return results;
    }

    protected void handleAnys(SyncDelta delta, List<PullMatch> matches, Provision provision) throws JobExecutionException {
        if (matches.isEmpty()) {
            LOG.debug("Nothing to do");
            return;
        }
        block0 : switch (delta.getDeltaType()) {
            case CREATE: 
            case UPDATE: 
            case CREATE_OR_UPDATE: {
                if (matches.get(0).getAny() == null) {
                    switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: 
                        case PROVISION: {
                            this.profile.getResults().addAll(this.provision(((PullTask)this.profile.getTask()).getUnmatchingRule(), delta, provision));
                            break block0;
                        }
                        case IGNORE: {
                            this.profile.getResults().addAll(this.ignore(delta, null, provision, false, new String[0]));
                            break block0;
                        }
                    }
                    break;
                }
                this.virSchemaDAO.findByProvision(provision).forEach(schema -> {
                    Attribute attr = delta.getObject().getAttributeByName(schema.getExtAttrName());
                    matches.forEach(match -> {
                        VirAttrCacheKey cacheKey = new VirAttrCacheKey(provision.getAnyType().getKey(), match.getAny().getKey(), schema.getKey());
                        if (attr == null) {
                            this.virAttrCache.expire(cacheKey);
                        } else {
                            this.virAttrCache.put(cacheKey, new VirAttrCacheValue((Collection)attr.getValue()));
                        }
                    });
                });
                switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                    case UPDATE: {
                        this.profile.getResults().addAll(this.update(delta, matches, provision));
                        break block0;
                    }
                    case DEPROVISION: 
                    case UNASSIGN: {
                        this.profile.getResults().addAll(this.deprovision(((PullTask)this.profile.getTask()).getMatchingRule(), delta, matches, provision));
                        break block0;
                    }
                    case LINK: {
                        this.profile.getResults().addAll(this.link(delta, matches, provision, false));
                        break block0;
                    }
                    case UNLINK: {
                        this.profile.getResults().addAll(this.link(delta, matches, provision, true));
                        break block0;
                    }
                    case IGNORE: {
                        this.profile.getResults().addAll(this.ignore(delta, matches, provision, true, new String[0]));
                        break block0;
                    }
                }
                break;
            }
            case DELETE: {
                if (matches.get(0).getAny() == null) {
                    this.end(provision.getAnyType().getKind(), MatchingRule.toEventName((MatchingRule)MatchingRule.IGNORE), AuditElements.Result.SUCCESS, null, null, delta, new Object[0]);
                    break;
                }
                this.profile.getResults().addAll(this.delete(delta, matches, provision));
                break;
            }
        }
    }

    protected void handleLinkedAccounts(SyncDelta delta, List<PullMatch> matches, Provision provision) throws JobExecutionException {
        if (matches.isEmpty()) {
            LOG.debug("Nothing to do");
            return;
        }
        LOG.warn("Unexpected linked accounts found for {}: {}", (Object)provision.getAnyType().getKind(), matches);
    }

    protected void doHandle(SyncDelta delta, Provision provision) throws JobExecutionException {
        LOG.debug("Process {} for {} as {}", new Object[]{delta.getDeltaType(), delta.getUid().getUidValue(), delta.getObject().getObjectClass()});
        SyncDelta finalDelta = delta;
        for (PullActions action : this.profile.getActions()) {
            finalDelta = action.preprocess(this.profile, finalDelta);
        }
        LOG.debug("Transformed {} for {} as {}", new Object[]{finalDelta.getDeltaType(), finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass()});
        try {
            List<PullMatch> matches = this.inboundMatcher.match(finalDelta, provision);
            LOG.debug("Match(es) found for {} as {}: {}", new Object[]{finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass(), matches});
            if (matches.size() > 1) {
                switch (this.profile.getConflictResolutionAction()) {
                    case IGNORE: {
                        throw new IgnoreProvisionException("More than one match found for " + finalDelta.getObject().getUid().getUidValue() + ": " + matches);
                    }
                    case FIRSTMATCH: {
                        matches = matches.subList(0, 1);
                        break;
                    }
                    case LASTMATCH: {
                        matches = matches.subList(matches.size() - 1, matches.size());
                        break;
                    }
                }
            }
            this.handleAnys(finalDelta, matches.stream().filter(match -> match.getMatchTarget() == MatchType.ANY).collect(Collectors.toList()), provision);
            this.handleLinkedAccounts(finalDelta, matches.stream().filter(match -> match.getMatchTarget() == MatchType.LINKED_ACCOUNT).collect(Collectors.toList()), provision);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(AnyTypeKind anyTypeKind, String event, AuditElements.Result result, Object before, Object output, SyncDelta delta, Object ... furtherInput) {
        AbstractPullResultHandler abstractPullResultHandler = this;
        synchronized (abstractPullResultHandler) {
            this.latestResult = result;
        }
        this.notificationManager.createTasks(AuthContextUtils.getWho(), AuditElements.EventCategoryType.PULL, anyTypeKind.name().toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta, furtherInput});
        this.auditManager.audit(AuthContextUtils.getWho(), AuditElements.EventCategoryType.PULL, anyTypeKind.name().toLowerCase(), ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta, furtherInput});
    }

    protected void createRemediationIfNeeded(AnyPatch anyPatch, SyncDelta delta, ProvisioningReport result) {
        if (ProvisioningReport.Status.FAILURE == result.getStatus() && ((PullTask)this.profile.getTask()).isRemediation()) {
            this.createRemediation(this.anyTypeDAO.find(result.getAnyType()), null, null, anyPatch, this.taskDAO.exists(TaskType.PULL, ((PullTask)this.profile.getTask()).getKey()) ? (PullTask)this.profile.getTask() : null, result, delta);
        }
    }

    protected void createRemediation(AnyType anyType, AnyPatch anyPatch, PullTask pullTask, ProvisioningReport result, SyncDelta delta) {
        this.createRemediation(anyType, null, null, anyPatch, pullTask, result, delta);
    }

    protected void createRemediation(AnyType anyType, String anyKey, AnyTO anyTO, AnyPatch anyPatch, PullTask pullTask, ProvisioningReport result, SyncDelta delta) {
        Remediation remediation = (Remediation)this.entityFactory.newEntity(Remediation.class);
        remediation.setAnyType(anyType);
        remediation.setOperation(anyPatch == null ? ResourceOperation.CREATE : ResourceOperation.UPDATE);
        if (StringUtils.isNotBlank((CharSequence)anyKey)) {
            remediation.setPayload(anyKey);
        } else if (anyTO != null) {
            remediation.setPayload(anyTO);
        } else if (anyPatch != null) {
            remediation.setPayload(anyPatch);
        }
        remediation.setError(result.getMessage());
        remediation.setInstant(new Date());
        remediation.setRemoteName(delta.getObject().getName().getNameValue());
        remediation.setPullTask(pullTask);
        remediation = this.remediationDAO.save(remediation);
        ProvisioningReport remediationResult = new ProvisioningReport();
        remediationResult.setOperation(remediation.getOperation());
        remediationResult.setAnyType(anyType.getKey());
        remediationResult.setStatus(ProvisioningReport.Status.FAILURE);
        remediationResult.setMessage(remediation.getError());
        if (StringUtils.isNotBlank((CharSequence)anyKey)) {
            remediationResult.setKey(anyKey);
        } else if (anyTO != null) {
            remediationResult.setKey(anyTO.getKey());
        } else if (anyPatch != null) {
            remediationResult.setKey(anyPatch.getKey());
        }
        remediationResult.setUidValue(delta.getUid().getUidValue());
        remediationResult.setName(remediation.getRemoteName());
        this.profile.getResults().add(remediationResult);
    }
}

