/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnitItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.TimeoutException;
import org.apache.syncope.core.provisioning.api.data.TaskDataBinder;
import org.apache.syncope.core.provisioning.api.event.AnyLifecycleEvent;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.retry.RetryException;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.ExponentialRandomBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public abstract class AbstractPropagationTaskExecutor
implements PropagationTaskExecutor {
    protected static final Logger LOG = LoggerFactory.getLogger(PropagationTaskExecutor.class);
    protected final Map<String, RetryTemplate> retryTemplates = Collections.synchronizedMap(new HashMap());
    @Autowired
    protected ConnectorFactory connFactory;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected TaskDataBinder taskDataBinder;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected TaskUtilsFactory taskUtilsFactory;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected OutboundMatcher outboundMatcher;
    @Autowired
    protected PlainAttrValidationManager validator;
    @Autowired
    protected ApplicationEventPublisher publisher;

    public void expireRetryTemplate(String resource) {
        this.retryTemplates.remove(resource);
    }

    protected List<PropagationActions> getPropagationActions(ExternalResource resource) {
        ArrayList<PropagationActions> result = new ArrayList<PropagationActions>();
        resource.getPropagationActions().forEach(impl -> {
            try {
                result.add((PropagationActions)ImplementationManager.build((Implementation)impl));
            }
            catch (Exception e) {
                LOG.error("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected Uid createOrUpdate(PropagationTask task, ConnectorObject beforeObj, Connector connector, AtomicReference<Boolean> propagationAttempted) {
        Uid result;
        Attribute mandatoryNullOrEmpty;
        HashSet attributes = new HashSet(task.getAttributes());
        HashSet mandatoryAttrNames = new HashSet();
        Attribute mandatoryMissing = AttributeUtil.find((String)"__MANDATORY_MISSING__", (Set)task.getAttributes());
        if (mandatoryMissing != null) {
            attributes.remove(mandatoryMissing);
            if (beforeObj == null) {
                mandatoryAttrNames.addAll(mandatoryMissing.getValue());
            }
        }
        if ((mandatoryNullOrEmpty = AttributeUtil.find((String)"__MANDATORY_NULL_OR_EMPTY__", (Set)task.getAttributes())) != null) {
            attributes.remove(mandatoryNullOrEmpty);
            mandatoryAttrNames.addAll(mandatoryNullOrEmpty.getValue());
        }
        if (!mandatoryAttrNames.isEmpty()) {
            throw new IllegalArgumentException("Not attempted because there are mandatory attributes without value(s): " + mandatoryAttrNames);
        }
        if (beforeObj == null) {
            LOG.debug("Create {} on {}", attributes, (Object)task.getResource().getKey());
            result = connector.create(new ObjectClass(task.getObjectClassName()), attributes, null, propagationAttempted);
            task.getResource().getProvision(task.getAnyType()).ifPresent(provision -> {
                if (provision.getUidOnCreate() != null) {
                    this.anyUtilsFactory.getInstance(task.getAnyTypeKind()).addAttr(this.validator, task.getEntityKey(), provision.getUidOnCreate(), result.getUidValue());
                    this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, this.userDAO.find(task.getEntityKey()), AuthContextUtils.getDomain()));
                }
            });
        } else {
            Name newName = AttributeUtil.getNameFromAttributes(attributes);
            LOG.debug("Rename required with value {}", (Object)newName);
            if (newName != null && newName.equals((Object)beforeObj.getName()) && !newName.getNameValue().equals(beforeObj.getUid().getUidValue())) {
                LOG.debug("Remote object name unchanged");
                attributes.remove(newName);
            }
            Map originalAttrMap = beforeObj.getAttributes().stream().collect(Collectors.toMap(attr -> attr.getName().toUpperCase(), Function.identity()));
            Map updateAttrMap = attributes.stream().collect(Collectors.toMap(attr -> attr.getName().toUpperCase(), Function.identity()));
            Set<String> skipAttrNames = originalAttrMap.keySet();
            skipAttrNames.removeAll(updateAttrMap.keySet());
            if (originalAttrMap.values().equals(attributes)) {
                LOG.debug("Don't need to propagate anything: {} is equal to {}", originalAttrMap.values(), attributes);
                result = AttributeUtil.getUidAttribute(attributes);
            } else {
                LOG.debug("Attributes that would be updated {}", attributes);
                LOG.debug("Update {} on {}", attributes, (Object)task.getResource().getKey());
                result = connector.update(beforeObj.getObjectClass(), new Uid(beforeObj.getUid().getUidValue()), attributes, null, propagationAttempted);
            }
        }
        return result;
    }

    protected Uid delete(PropagationTask task, ConnectorObject beforeObj, Connector connector, AtomicReference<Boolean> propagationAttempted) {
        Uid result;
        if (beforeObj == null) {
            LOG.debug("{} not found on {}: ignoring delete", (Object)task.getConnObjectKey(), (Object)task.getResource().getKey());
            result = null;
        } else {
            LOG.debug("Delete {} on {}", (Object)beforeObj.getUid(), (Object)task.getResource().getKey());
            connector.delete(beforeObj.getObjectClass(), beforeObj.getUid(), null, propagationAttempted);
            result = beforeObj.getUid();
        }
        return result;
    }

    protected PropagationTask buildTask(PropagationTaskInfo taskInfo) {
        PropagationTask task;
        if (taskInfo.getKey() == null) {
            ExternalResource resource = this.resourceDAO.find(taskInfo.getResource());
            if (resource == null) {
                resource = taskInfo.getExternalResource();
            }
            task = (PropagationTask)this.entityFactory.newEntity(PropagationTask.class);
            task.setResource(resource);
            task.setObjectClassName(taskInfo.getObjectClassName());
            task.setAnyTypeKind(taskInfo.getAnyTypeKind());
            task.setAnyType(taskInfo.getAnyType());
            task.setEntityKey(taskInfo.getEntityKey());
            task.setOperation(taskInfo.getOperation());
            task.setConnObjectKey(taskInfo.getConnObjectKey());
            task.setOldConnObjectKey(taskInfo.getOldConnObjectKey());
        } else {
            task = (PropagationTask)this.taskDAO.find(taskInfo.getKey());
        }
        HashSet<Object> attributes = new HashSet<Object>();
        if (StringUtils.isNotBlank((CharSequence)taskInfo.getAttributes())) {
            attributes.addAll(Arrays.asList((Object[])POJOHelper.deserialize((String)taskInfo.getAttributes(), Attribute[].class)));
        }
        task.setAttributes(attributes);
        return task;
    }

    protected Optional<RetryTemplate> retryTemplate(ExternalResource resource) {
        RetryTemplate retryTemplate = null;
        if (resource.getPropagationPolicy() != null && (retryTemplate = this.retryTemplates.get(resource.getKey())) == null) {
            retryTemplate = new RetryTemplate();
            SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
            retryPolicy.setMaxAttempts(resource.getPropagationPolicy().getMaxAttempts());
            retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
            String[] params = resource.getPropagationPolicy().getBackOffParams().split(";");
            switch (resource.getPropagationPolicy().getBackOffStrategy()) {
                case EXPONENTIAL: {
                    ExponentialBackOffPolicy eBackOffPolicy = new ExponentialBackOffPolicy();
                    if (params.length > 0) {
                        try {
                            eBackOffPolicy.setInitialInterval(Long.parseLong(params[0]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[0], (Object)e);
                        }
                    }
                    if (params.length > 1) {
                        try {
                            eBackOffPolicy.setMaxInterval(Long.parseLong(params[1]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[1], (Object)e);
                        }
                    }
                    if (params.length > 2) {
                        try {
                            eBackOffPolicy.setMultiplier(Double.parseDouble(params[2]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to double: {}", (Object)params[2], (Object)e);
                        }
                    }
                    retryTemplate.setBackOffPolicy((BackOffPolicy)eBackOffPolicy);
                    break;
                }
                case RANDOM: {
                    ExponentialRandomBackOffPolicy erBackOffPolicy = new ExponentialRandomBackOffPolicy();
                    if (params.length > 0) {
                        try {
                            erBackOffPolicy.setInitialInterval(Long.parseLong(params[0]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[0], (Object)e);
                        }
                    }
                    if (params.length > 1) {
                        try {
                            erBackOffPolicy.setMaxInterval(Long.parseLong(params[1]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[1], (Object)e);
                        }
                    }
                    if (params.length > 2) {
                        try {
                            erBackOffPolicy.setMultiplier(Double.parseDouble(params[2]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to double: {}", (Object)params[2], (Object)e);
                        }
                    }
                    retryTemplate.setBackOffPolicy((BackOffPolicy)erBackOffPolicy);
                    break;
                }
                default: {
                    FixedBackOffPolicy fBackOffPolicy = new FixedBackOffPolicy();
                    if (params.length > 0) {
                        try {
                            fBackOffPolicy.setBackOffPeriod(Long.parseLong(params[0]));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Could not convert to long: {}", (Object)params[0], (Object)e);
                        }
                    }
                    retryTemplate.setBackOffPolicy((BackOffPolicy)fBackOffPolicy);
                }
            }
            this.retryTemplates.put(resource.getKey(), retryTemplate);
        }
        return Optional.ofNullable(retryTemplate);
    }

    public TaskExec execute(PropagationTaskInfo taskInfo, PropagationReporter reporter) {
        PropagationTask task = this.buildTask(taskInfo);
        return this.retryTemplate(task.getResource()).map(rt -> (TaskExec)rt.execute(context -> {
            LOG.debug("#{} Propagation attempt", (Object)context.getRetryCount());
            TaskExec exec = this.doExecute(taskInfo, task, reporter);
            if (context.getRetryCount() < task.getResource().getPropagationPolicy().getMaxAttempts() - 1 && !ExecStatus.SUCCESS.name().equals(exec.getStatus())) {
                throw new RetryException("Attempt #" + context.getRetryCount() + " failed");
            }
            return exec;
        })).orElseGet(() -> this.doExecute(taskInfo, task, reporter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected TaskExec doExecute(PropagationTaskInfo taskInfo, PropagationTask task, PropagationReporter reporter) {
        AuditElements.Result result;
        ConnectorObject afterObj;
        ConnectorObject beforeObj;
        TaskExec exec;
        List<PropagationActions> actions;
        block36: {
            Uid uid;
            OrgUnit orgUnit;
            Provision provision;
            AtomicReference<Boolean> propagationAttempted;
            String failureReason;
            String taskExecutionMessage;
            Date start;
            Connector connector;
            block32: {
                block33: {
                    connector = taskInfo.getConnector() == null ? this.connFactory.getConnector(task.getResource()) : taskInfo.getConnector();
                    actions = this.getPropagationActions(task.getResource());
                    start = new Date();
                    exec = (TaskExec)this.entityFactory.newEntity(TaskExec.class);
                    exec.setStatus(ExecStatus.CREATED.name());
                    taskExecutionMessage = null;
                    failureReason = null;
                    propagationAttempted = new AtomicReference<Boolean>(false);
                    beforeObj = null;
                    afterObj = null;
                    provision = null;
                    orgUnit = null;
                    uid = null;
                    provision = task.getResource().getProvision(new ObjectClass(task.getObjectClassName())).orElse(null);
                    orgUnit = task.getResource().getOrgUnit();
                    if (taskInfo.getBeforeObj() == null || !taskInfo.getBeforeObj().isPresent()) {
                        beforeObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(task, connector, provision, actions, false) : this.getRemoteObject(task, connector, orgUnit, actions, false));
                    } else if (taskInfo.getBeforeObj().isPresent()) {
                        beforeObj = (ConnectorObject)taskInfo.getBeforeObj().get();
                    }
                    for (PropagationActions action2 : actions) {
                        action2.before(task, beforeObj);
                    }
                    switch (task.getOperation()) {
                        case CREATE: 
                        case UPDATE: {
                            uid = this.createOrUpdate(task, beforeObj, connector, propagationAttempted);
                            break;
                        }
                        case DELETE: {
                            uid = this.delete(task, beforeObj, connector, propagationAttempted);
                            break;
                        }
                    }
                    exec.setStatus(propagationAttempted.get() != false ? ExecStatus.SUCCESS.name() : ExecStatus.NOT_ATTEMPTED.name());
                    LOG.debug("Successfully propagated to {}", (Object)task.getResource());
                    result = AuditElements.Result.SUCCESS;
                    if (connector == null) break block32;
                    if (uid == null) break block33;
                    task.setConnObjectKey(uid.getUidValue());
                }
                try {
                    afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(task, connector, provision, actions, true) : this.getRemoteObject(task, connector, orgUnit, actions, true));
                }
                catch (Exception ignore) {
                    LOG.error("Error retrieving after object", (Throwable)ignore);
                }
            }
            if (task.getOperation() != ResourceOperation.DELETE && afterObj == null && uid != null) {
                afterObj = new ConnectorObjectBuilder().setObjectClass(new ObjectClass(task.getObjectClassName())).setUid(uid).setName(AttributeUtil.getNameFromAttributes((Set)task.getAttributes())).build();
            }
            exec.setStart(start);
            exec.setMessage(taskExecutionMessage);
            exec.setEnd(new Date());
            LOG.debug("Execution finished: {}", (Object)exec);
            if (this.hasToBeregistered(task, exec)) {
                LOG.debug("Execution to be stored: {}", (Object)exec);
                exec.setTask((Task)task);
                task.add(exec);
                this.taskDAO.save((Task)task);
            }
            Object fiql = provision == null ? null : (afterObj != null ? this.outboundMatcher.getFIQL(afterObj, provision) : (beforeObj != null ? this.outboundMatcher.getFIQL(beforeObj, provision) : null));
            reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.valueOf((String)exec.getStatus()), failureReason, (String)fiql, beforeObj, afterObj);
            break block36;
            catch (Exception e) {
                block34: {
                    block35: {
                        try {
                            result = AuditElements.Result.FAILURE;
                            LOG.error("Exception during provision on resource " + task.getResource().getKey(), (Throwable)e);
                            if (e instanceof ConnectorException && e.getCause() != null) {
                                taskExecutionMessage = e.getCause().getMessage();
                                failureReason = e.getCause().getMessage() == null ? e.getMessage() : e.getMessage() + "\n\n Cause: " + e.getCause().getMessage().split("\n")[0];
                            } else {
                                taskExecutionMessage = ExceptionUtils2.getFullStackTrace((Throwable)e);
                                failureReason = e.getCause() == null ? e.getMessage() : e.getMessage() + "\n\n Cause: " + e.getCause().getMessage().split("\n")[0];
                            }
                            try {
                                exec.setStatus(ExecStatus.FAILURE.name());
                            }
                            catch (Exception wft) {
                                LOG.error("While executing KO action on {}", (Object)exec, (Object)wft);
                            }
                            propagationAttempted.set(true);
                            actions.forEach(action -> action.onError(task, exec, e));
                            if (connector == null) break block34;
                            if (uid == null) break block35;
                        }
                        catch (Throwable throwable) {
                            if (connector != null) {
                                if (uid != null) {
                                    task.setConnObjectKey(uid.getUidValue());
                                }
                                try {
                                    afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(task, connector, provision, actions, true) : this.getRemoteObject(task, connector, orgUnit, actions, true));
                                }
                                catch (Exception ignore) {
                                    LOG.error("Error retrieving after object", (Throwable)ignore);
                                }
                            }
                            if (task.getOperation() != ResourceOperation.DELETE && afterObj == null && uid != null) {
                                afterObj = new ConnectorObjectBuilder().setObjectClass(new ObjectClass(task.getObjectClassName())).setUid(uid).setName(AttributeUtil.getNameFromAttributes((Set)task.getAttributes())).build();
                            }
                            exec.setStart(start);
                            exec.setMessage(taskExecutionMessage);
                            exec.setEnd(new Date());
                            LOG.debug("Execution finished: {}", (Object)exec);
                            if (this.hasToBeregistered(task, exec)) {
                                LOG.debug("Execution to be stored: {}", (Object)exec);
                                exec.setTask((Task)task);
                                task.add(exec);
                                this.taskDAO.save((Task)task);
                            }
                            String fiql2 = provision == null ? null : (afterObj != null ? this.outboundMatcher.getFIQL(afterObj, provision) : (beforeObj != null ? this.outboundMatcher.getFIQL(beforeObj, provision) : null));
                            reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.valueOf((String)exec.getStatus()), failureReason, fiql2, beforeObj, afterObj);
                            throw throwable;
                        }
                        task.setConnObjectKey(uid.getUidValue());
                    }
                    try {
                        afterObj = provision == null && orgUnit == null ? null : (orgUnit == null ? this.getRemoteObject(task, connector, provision, actions, true) : this.getRemoteObject(task, connector, orgUnit, actions, true));
                    }
                    catch (Exception ignore) {
                        LOG.error("Error retrieving after object", (Throwable)ignore);
                    }
                }
                if (task.getOperation() != ResourceOperation.DELETE && afterObj == null && uid != null) {
                    afterObj = new ConnectorObjectBuilder().setObjectClass(new ObjectClass(task.getObjectClassName())).setUid(uid).setName(AttributeUtil.getNameFromAttributes((Set)task.getAttributes())).build();
                }
                exec.setStart(start);
                exec.setMessage(taskExecutionMessage);
                exec.setEnd(new Date());
                LOG.debug("Execution finished: {}", (Object)exec);
                if (this.hasToBeregistered(task, exec)) {
                    LOG.debug("Execution to be stored: {}", (Object)exec);
                    exec.setTask((Task)task);
                    task.add(exec);
                    this.taskDAO.save((Task)task);
                }
                fiql = provision == null ? null : (afterObj != null ? this.outboundMatcher.getFIQL(afterObj, provision) : (beforeObj != null ? this.outboundMatcher.getFIQL(beforeObj, provision) : null));
                reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.valueOf((String)exec.getStatus()), failureReason, (String)fiql, beforeObj, afterObj);
            }
        }
        for (PropagationActions action2 : actions) {
            action2.after(task, exec, afterObj);
        }
        String anyTypeKind = Optional.ofNullable(task.getAnyTypeKind()).map(Enum::name).orElse("realm");
        String operation = task.getOperation().name().toLowerCase();
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuditElements.EventCategoryType.PROPAGATION, anyTypeKind, task.getResource().getKey(), operation);
        boolean auditRequested = this.auditManager.auditRequested(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.PROPAGATION, anyTypeKind, task.getResource().getKey(), operation);
        if (notificationsAvailable || auditRequested) {
            ExecTO execTO = this.taskDataBinder.getExecTO(exec);
            this.notificationManager.createTasks(AuthContextUtils.getWho(), AuditElements.EventCategoryType.PROPAGATION, anyTypeKind, task.getResource().getKey(), operation, result, (Object)beforeObj, (Object)new Object[]{execTO, afterObj}, new Object[]{taskInfo});
            this.auditManager.audit(AuthContextUtils.getWho(), AuditElements.EventCategoryType.PROPAGATION, anyTypeKind, task.getResource().getKey(), operation, result, (Object)beforeObj, (Object)new Object[]{execTO, afterObj}, new Object[]{taskInfo});
        }
        return exec;
    }

    protected TaskExec rejected(PropagationTaskInfo taskInfo, String rejectReason, PropagationReporter reporter) {
        PropagationTask task = this.buildTask(taskInfo);
        TaskExec execution = (TaskExec)this.entityFactory.newEntity(TaskExec.class);
        execution.setStatus(ExecStatus.NOT_ATTEMPTED.name());
        execution.setStart(new Date());
        execution.setMessage(rejectReason);
        execution.setEnd(execution.getStart());
        if (this.hasToBeregistered(task, execution)) {
            LOG.debug("Execution to be stored: {}", (Object)execution);
            execution.setTask((Task)task);
            task.add(execution);
            this.taskDAO.save((Task)task);
        }
        reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.valueOf((String)execution.getStatus()), rejectReason, null, null, null);
        return execution;
    }

    protected boolean hasToBeregistered(PropagationTask task, TaskExec execution) {
        boolean result;
        boolean failed = ExecStatus.valueOf((String)execution.getStatus()) != ExecStatus.SUCCESS;
        switch (task.getOperation()) {
            case CREATE: {
                result = failed && task.getResource().getCreateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getCreateTraceLevel() == TraceLevel.ALL;
                break;
            }
            case UPDATE: {
                result = failed && task.getResource().getUpdateTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getUpdateTraceLevel() == TraceLevel.ALL;
                break;
            }
            case DELETE: {
                result = failed && task.getResource().getDeleteTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getResource().getDeleteTraceLevel() == TraceLevel.ALL;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected ConnectorObject getRemoteObject(PropagationTask task, Connector connector, Provision provision, List<PropagationActions> actions, boolean latest) {
        String connObjectKeyValue = latest || task.getOldConnObjectKey() == null ? task.getConnObjectKey() : task.getOldConnObjectKey();
        List<ConnectorObject> matches = this.outboundMatcher.match(task, connector, provision, actions, connObjectKeyValue);
        LOG.debug("Found for propagation task {}: {}", (Object)task, matches);
        return matches.isEmpty() ? null : matches.get(0);
    }

    protected ConnectorObject getRemoteObject(PropagationTask task, Connector connector, OrgUnit orgUnit, List<PropagationActions> actions, boolean latest) {
        String connObjectKey = latest || task.getOldConnObjectKey() == null ? task.getConnObjectKey() : task.getOldConnObjectKey();
        HashSet moreAttrsToGet = new HashSet();
        actions.forEach(action -> moreAttrsToGet.addAll(action.moreAttrsToGet(Optional.of(task), orgUnit)));
        ConnectorObject obj = null;
        Optional connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem.isPresent()) {
            try {
                obj = connector.getObject(new ObjectClass(task.getObjectClassName()), AttributeBuilder.build((String)((OrgUnitItem)connObjectKeyItem.get()).getExtAttrName(), (Object[])new Object[]{connObjectKey}), orgUnit.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions(MappingUtils.getPropagationItems(orgUnit.getItems().stream()), moreAttrsToGet.toArray(new String[0])));
            }
            catch (TimeoutException toe) {
                LOG.debug("Request timeout", (Throwable)toe);
                throw toe;
            }
            catch (RuntimeException ignore) {
                LOG.debug("While resolving {}", (Object)connObjectKey, (Object)ignore);
            }
        }
        return obj;
    }
}

